/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUdpDst;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUdpDstVer13
implements OFBsnTlvUdpDst {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUdpDstVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvUdpDstVer13 DEFAULT = new OFBsnTlvUdpDstVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvUdpDstVer13Funnel FUNNEL = new OFBsnTlvUdpDstVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUdpDstVer13(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 37;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvUdpDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUdpDstVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUdpDstVer13 other = (OFBsnTlvUdpDstVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUdpDstVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUdpDstVer13 message) {
            bb.writeShort(37);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvUdpDstVer13Funnel
    implements Funnel<OFBsnTlvUdpDstVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUdpDstVer13Funnel() {
        }

        public void funnel(OFBsnTlvUdpDstVer13 message, PrimitiveSink sink) {
            sink.putShort((short)37);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUdpDst> {
        Reader() {
        }

        @Override
        public OFBsnTlvUdpDst readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 37) {
                throw new OFParseError("Wrong type: Expected=0x25(0x25), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvUdpDstVer13 bsnTlvUdpDstVer13 = new OFBsnTlvUdpDstVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUdpDstVer13);
            }
            return bsnTlvUdpDstVer13;
        }
    }

    static class Builder
    implements OFBsnTlvUdpDst.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 37;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdpDst.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUdpDst build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvUdpDstVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUdpDst.Builder {
        final OFBsnTlvUdpDstVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvUdpDstVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 37;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdpDst.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUdpDst build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUdpDstVer13(value);
        }
    }
}

