/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvSubAgentId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvSubAgentIdVer13
implements OFBsnTlvSubAgentId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvSubAgentIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvSubAgentIdVer13 DEFAULT = new OFBsnTlvSubAgentIdVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvSubAgentIdVer13Funnel FUNNEL = new OFBsnTlvSubAgentIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvSubAgentIdVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 38;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvSubAgentId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvSubAgentIdVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvSubAgentIdVer13 other = (OFBsnTlvSubAgentIdVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvSubAgentIdVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvSubAgentIdVer13 message) {
            bb.writeShort(38);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvSubAgentIdVer13Funnel
    implements Funnel<OFBsnTlvSubAgentIdVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvSubAgentIdVer13Funnel() {
        }

        public void funnel(OFBsnTlvSubAgentIdVer13 message, PrimitiveSink sink) {
            sink.putShort((short)38);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvSubAgentId> {
        Reader() {
        }

        @Override
        public OFBsnTlvSubAgentId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 38) {
                throw new OFParseError("Wrong type: Expected=0x26(0x26), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvSubAgentIdVer13 bsnTlvSubAgentIdVer13 = new OFBsnTlvSubAgentIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvSubAgentIdVer13);
            }
            return bsnTlvSubAgentIdVer13;
        }
    }

    static class Builder
    implements OFBsnTlvSubAgentId.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 38;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSubAgentId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvSubAgentId build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvSubAgentIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvSubAgentId.Builder {
        final OFBsnTlvSubAgentIdVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvSubAgentIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 38;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSubAgentId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvSubAgentId build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvSubAgentIdVer13(value);
        }
    }
}

