/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvQueueWeight;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvQueueWeightVer13
implements OFBsnTlvQueueWeight {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvQueueWeightVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvQueueWeightVer13 DEFAULT = new OFBsnTlvQueueWeightVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvQueueWeightVer13Funnel FUNNEL = new OFBsnTlvQueueWeightVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvQueueWeightVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 21;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvQueueWeight.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvQueueWeightVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvQueueWeightVer13 other = (OFBsnTlvQueueWeightVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvQueueWeightVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvQueueWeightVer13 message) {
            bb.writeShort(21);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvQueueWeightVer13Funnel
    implements Funnel<OFBsnTlvQueueWeightVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvQueueWeightVer13Funnel() {
        }

        public void funnel(OFBsnTlvQueueWeightVer13 message, PrimitiveSink sink) {
            sink.putShort((short)21);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvQueueWeight> {
        Reader() {
        }

        @Override
        public OFBsnTlvQueueWeight readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 21) {
                throw new OFParseError("Wrong type: Expected=0x15(0x15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvQueueWeightVer13 bsnTlvQueueWeightVer13 = new OFBsnTlvQueueWeightVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvQueueWeightVer13);
            }
            return bsnTlvQueueWeightVer13;
        }
    }

    static class Builder
    implements OFBsnTlvQueueWeight.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 21;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvQueueWeight.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvQueueWeight build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvQueueWeightVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvQueueWeight.Builder {
        final OFBsnTlvQueueWeightVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvQueueWeightVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 21;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvQueueWeight.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvQueueWeight build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvQueueWeightVer13(value);
        }
    }
}

