/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPortMode;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPortMode;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnPortModeSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPortModeVer13
implements OFBsnTlvPortMode {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPortModeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnPortMode value;
    static final Reader READER = new Reader();
    static final OFBsnTlvPortModeVer13Funnel FUNNEL = new OFBsnTlvPortModeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPortModeVer13(OFBsnPortMode value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPortModeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 179;
    }

    @Override
    public OFBsnPortMode getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvPortMode.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPortModeVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPortModeVer13 other = (OFBsnTlvPortModeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPortModeVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPortModeVer13 message) {
            bb.writeShort(179);
            bb.writeShort(6);
            OFBsnPortModeSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPortModeVer13Funnel
    implements Funnel<OFBsnTlvPortModeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPortModeVer13Funnel() {
        }

        public void funnel(OFBsnTlvPortModeVer13 message, PrimitiveSink sink) {
            sink.putShort((short)179);
            sink.putShort((short)6);
            OFBsnPortModeSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPortMode> {
        Reader() {
        }

        @Override
        public OFBsnTlvPortMode readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 179) {
                throw new OFParseError("Wrong type: Expected=0xb3(0xb3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnPortMode value = OFBsnPortModeSerializerVer13.readFrom(bb);
            OFBsnTlvPortModeVer13 bsnTlvPortModeVer13 = new OFBsnTlvPortModeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPortModeVer13);
            }
            return bsnTlvPortModeVer13;
        }
    }

    static class Builder
    implements OFBsnTlvPortMode.Builder {
        private boolean valueSet;
        private OFBsnPortMode value;

        Builder() {
        }

        @Override
        public int getType() {
            return 179;
        }

        @Override
        public OFBsnPortMode getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortMode.Builder setValue(OFBsnPortMode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPortMode build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortModeVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPortMode.Builder {
        final OFBsnTlvPortModeVer13 parentMessage;
        private boolean valueSet;
        private OFBsnPortMode value;

        BuilderWithParent(OFBsnTlvPortModeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 179;
        }

        @Override
        public OFBsnPortMode getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortMode.Builder setValue(OFBsnPortMode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPortMode build() {
            OFBsnPortMode value;
            OFBsnPortMode oFBsnPortMode = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortModeVer13(value);
        }
    }
}

