/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvL3SrcClassId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvL3SrcClassIdVer13
implements OFBsnTlvL3SrcClassId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvL3SrcClassIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvL3SrcClassIdVer13 DEFAULT = new OFBsnTlvL3SrcClassIdVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvL3SrcClassIdVer13Funnel FUNNEL = new OFBsnTlvL3SrcClassIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvL3SrcClassIdVer13(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 135;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvL3SrcClassId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvL3SrcClassIdVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvL3SrcClassIdVer13 other = (OFBsnTlvL3SrcClassIdVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvL3SrcClassIdVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvL3SrcClassIdVer13 message) {
            bb.writeShort(135);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvL3SrcClassIdVer13Funnel
    implements Funnel<OFBsnTlvL3SrcClassIdVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvL3SrcClassIdVer13Funnel() {
        }

        public void funnel(OFBsnTlvL3SrcClassIdVer13 message, PrimitiveSink sink) {
            sink.putShort((short)135);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvL3SrcClassId> {
        Reader() {
        }

        @Override
        public OFBsnTlvL3SrcClassId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 135) {
                throw new OFParseError("Wrong type: Expected=0x87(0x87), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvL3SrcClassIdVer13 bsnTlvL3SrcClassIdVer13 = new OFBsnTlvL3SrcClassIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvL3SrcClassIdVer13);
            }
            return bsnTlvL3SrcClassIdVer13;
        }
    }

    static class Builder
    implements OFBsnTlvL3SrcClassId.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 135;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvL3SrcClassId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvL3SrcClassId build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvL3SrcClassIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvL3SrcClassId.Builder {
        final OFBsnTlvL3SrcClassIdVer13 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvL3SrcClassIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 135;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvL3SrcClassId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvL3SrcClassId build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvL3SrcClassIdVer13(value);
        }
    }
}

