/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIcmpType;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIcmpTypeVer13
implements OFBsnTlvIcmpType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIcmpTypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvIcmpTypeVer13 DEFAULT = new OFBsnTlvIcmpTypeVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIcmpTypeVer13Funnel FUNNEL = new OFBsnTlvIcmpTypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIcmpTypeVer13(short value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 68;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvIcmpType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIcmpTypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIcmpTypeVer13 other = (OFBsnTlvIcmpTypeVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIcmpTypeVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIcmpTypeVer13 message) {
            bb.writeShort(68);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvIcmpTypeVer13Funnel
    implements Funnel<OFBsnTlvIcmpTypeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIcmpTypeVer13Funnel() {
        }

        public void funnel(OFBsnTlvIcmpTypeVer13 message, PrimitiveSink sink) {
            sink.putShort((short)68);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIcmpType> {
        Reader() {
        }

        @Override
        public OFBsnTlvIcmpType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 68) {
                throw new OFParseError("Wrong type: Expected=0x44(0x44), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvIcmpTypeVer13 bsnTlvIcmpTypeVer13 = new OFBsnTlvIcmpTypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIcmpTypeVer13);
            }
            return bsnTlvIcmpTypeVer13;
        }
    }

    static class Builder
    implements OFBsnTlvIcmpType.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 68;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpType.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIcmpType build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvIcmpTypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIcmpType.Builder {
        final OFBsnTlvIcmpTypeVer13 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvIcmpTypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 68;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpType.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIcmpType build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIcmpTypeVer13(value);
        }
    }
}

