/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBucket;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnTlvVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBucketVer13
implements OFBsnTlvBucket {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBucketVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFBsnTlv> DEFAULT_VALUE = ImmutableList.of();
    private final List<OFBsnTlv> value;
    static final OFBsnTlvBucketVer13 DEFAULT = new OFBsnTlvBucketVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvBucketVer13Funnel FUNNEL = new OFBsnTlvBucketVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBucketVer13(List<OFBsnTlv> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvBucketVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public List<OFBsnTlv> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvBucket.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBucketVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBucketVer13 other = (OFBsnTlvBucketVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBucketVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBucketVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(64);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.value);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvBucketVer13Funnel
    implements Funnel<OFBsnTlvBucketVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBucketVer13Funnel() {
        }

        public void funnel(OFBsnTlvBucketVer13 message, PrimitiveSink sink) {
            sink.putShort((short)64);
            FunnelUtils.putList(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBucket> {
        Reader() {
        }

        @Override
        public OFBsnTlvBucket readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 64) {
                throw new OFParseError("Wrong type: Expected=0x40(0x40), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFBsnTlv> value = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer13.READER);
            OFBsnTlvBucketVer13 bsnTlvBucketVer13 = new OFBsnTlvBucketVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBucketVer13);
            }
            return bsnTlvBucketVer13;
        }
    }

    static class Builder
    implements OFBsnTlvBucket.Builder {
        private boolean valueSet;
        private List<OFBsnTlv> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 64;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBucket.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvBucket build() {
            List<OFBsnTlv> value;
            List<OFBsnTlv> list = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBucketVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBucket.Builder {
        final OFBsnTlvBucketVer13 parentMessage;
        private boolean valueSet;
        private List<OFBsnTlv> value;

        BuilderWithParent(OFBsnTlvBucketVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 64;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBucket.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvBucket build() {
            List value;
            List list = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBucketVer13(value);
        }
    }
}

