/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvActorSystemPriority;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvActorSystemPriorityVer13
implements OFBsnTlvActorSystemPriority {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvActorSystemPriorityVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvActorSystemPriorityVer13 DEFAULT = new OFBsnTlvActorSystemPriorityVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvActorSystemPriorityVer13Funnel FUNNEL = new OFBsnTlvActorSystemPriorityVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvActorSystemPriorityVer13(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 40;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvActorSystemPriority.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvActorSystemPriorityVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvActorSystemPriorityVer13 other = (OFBsnTlvActorSystemPriorityVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvActorSystemPriorityVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvActorSystemPriorityVer13 message) {
            bb.writeShort(40);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvActorSystemPriorityVer13Funnel
    implements Funnel<OFBsnTlvActorSystemPriorityVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvActorSystemPriorityVer13Funnel() {
        }

        public void funnel(OFBsnTlvActorSystemPriorityVer13 message, PrimitiveSink sink) {
            sink.putShort((short)40);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvActorSystemPriority> {
        Reader() {
        }

        @Override
        public OFBsnTlvActorSystemPriority readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 40) {
                throw new OFParseError("Wrong type: Expected=0x28(0x28), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvActorSystemPriorityVer13 bsnTlvActorSystemPriorityVer13 = new OFBsnTlvActorSystemPriorityVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvActorSystemPriorityVer13);
            }
            return bsnTlvActorSystemPriorityVer13;
        }
    }

    static class Builder
    implements OFBsnTlvActorSystemPriority.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 40;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorSystemPriority.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvActorSystemPriority build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvActorSystemPriorityVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvActorSystemPriority.Builder {
        final OFBsnTlvActorSystemPriorityVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvActorSystemPriorityVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 40;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvActorSystemPriority.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvActorSystemPriority build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvActorSystemPriorityVer13(value);
        }
    }
}

