/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableBucketStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U128;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableBucketStatsEntryVer13
implements OFBsnGentableBucketStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableBucketStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private final U128 checksum;
    static final OFBsnGentableBucketStatsEntryVer13 DEFAULT = new OFBsnGentableBucketStatsEntryVer13(DEFAULT_CHECKSUM);
    static final Reader READER = new Reader();
    static final OFBsnGentableBucketStatsEntryVer13Funnel FUNNEL = new OFBsnGentableBucketStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableBucketStatsEntryVer13(U128 checksum) {
        if (checksum == null) {
            throw new NullPointerException("OFBsnGentableBucketStatsEntryVer13: property checksum cannot be null");
        }
        this.checksum = checksum;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnGentableBucketStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableBucketStatsEntryVer13(");
        b.append("checksum=").append(this.checksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableBucketStatsEntryVer13 other = (OFBsnGentableBucketStatsEntryVer13)obj;
        return !(this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableBucketStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableBucketStatsEntryVer13 message) {
            message.checksum.write16Bytes(bb);
        }
    }

    static class OFBsnGentableBucketStatsEntryVer13Funnel
    implements Funnel<OFBsnGentableBucketStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableBucketStatsEntryVer13Funnel() {
        }

        public void funnel(OFBsnGentableBucketStatsEntryVer13 message, PrimitiveSink sink) {
            message.checksum.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableBucketStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGentableBucketStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            U128 checksum = U128.read16Bytes(bb);
            OFBsnGentableBucketStatsEntryVer13 bsnGentableBucketStatsEntryVer13 = new OFBsnGentableBucketStatsEntryVer13(checksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableBucketStatsEntryVer13);
            }
            return bsnGentableBucketStatsEntryVer13;
        }
    }

    static class Builder
    implements OFBsnGentableBucketStatsEntry.Builder {
        private boolean checksumSet;
        private U128 checksum;

        Builder() {
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableBucketStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnGentableBucketStatsEntry build() {
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnGentableBucketStatsEntryVer13(checksum);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableBucketStatsEntry.Builder {
        final OFBsnGentableBucketStatsEntryVer13 parentMessage;
        private boolean checksumSet;
        private U128 checksum;

        BuilderWithParent(OFBsnGentableBucketStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableBucketStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnGentableBucketStatsEntry build() {
            U128 checksum;
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnGentableBucketStatsEntryVer13(checksum);
        }
    }
}

