/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnControllerConnectionsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnControllerConnectionsRequestVer13
implements OFBsnControllerConnectionsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnControllerConnectionsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBsnControllerConnectionsRequestVer13 DEFAULT = new OFBsnControllerConnectionsRequestVer13(0L);
    static final Reader READER = new Reader();
    static final OFBsnControllerConnectionsRequestVer13Funnel FUNNEL = new OFBsnControllerConnectionsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnControllerConnectionsRequestVer13(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 56L;
    }

    @Override
    public OFBsnControllerConnectionsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnControllerConnectionsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnControllerConnectionsRequestVer13 other = (OFBsnControllerConnectionsRequestVer13)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnControllerConnectionsRequestVer13 other = (OFBsnControllerConnectionsRequestVer13)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnControllerConnectionsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnControllerConnectionsRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(56);
        }
    }

    static class OFBsnControllerConnectionsRequestVer13Funnel
    implements Funnel<OFBsnControllerConnectionsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnControllerConnectionsRequestVer13Funnel() {
        }

        public void funnel(OFBsnControllerConnectionsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(56);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnControllerConnectionsRequest> {
        Reader() {
        }

        @Override
        public OFBsnControllerConnectionsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 56) {
                throw new OFParseError("Wrong subtype: Expected=0x38L(0x38L), got=" + subtype);
            }
            OFBsnControllerConnectionsRequestVer13 bsnControllerConnectionsRequestVer13 = new OFBsnControllerConnectionsRequestVer13(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnControllerConnectionsRequestVer13);
            }
            return bsnControllerConnectionsRequestVer13;
        }
    }

    static class Builder
    implements OFBsnControllerConnectionsRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnControllerConnectionsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 56L;
        }

        @Override
        public OFBsnControllerConnectionsRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBsnControllerConnectionsRequestVer13(xid);
        }
    }

    static class BuilderWithParent
    implements OFBsnControllerConnectionsRequest.Builder {
        final OFBsnControllerConnectionsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBsnControllerConnectionsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnControllerConnectionsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 56L;
        }

        @Override
        public OFBsnControllerConnectionsRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBsnControllerConnectionsRequestVer13(xid);
        }
    }
}

