/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver12.OFBarrierReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFBarrierRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFEchoReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFEchoRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFErrorMsgVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFExperimenterVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFFeaturesReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFFeaturesRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFFlowModVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFFlowRemovedVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGetConfigReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGetConfigRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupModVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFHelloVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFPacketInVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFPacketOutVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFPortModVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFPortStatusVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFQueueGetConfigReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFQueueGetConfigRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFRoleReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFRoleRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFSetConfigVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFStatsReplyVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFTableModVer12;

abstract class OFMessageVer12 {
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFMessageVer12() {
    }

    static class Reader
    implements OFMessageReader<OFMessage> {
        Reader() {
        }

        @Override
        public OFMessage readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            bb.readerIndex(start);
            switch (type) {
                case 19: {
                    return OFStatsReplyVer12.READER.readFrom(bb);
                }
                case 18: {
                    return OFStatsRequestVer12.READER.readFrom(bb);
                }
                case 1: {
                    return OFErrorMsgVer12.READER.readFrom(bb);
                }
                case 21: {
                    return OFBarrierReplyVer12.READER.readFrom(bb);
                }
                case 20: {
                    return OFBarrierRequestVer12.READER.readFrom(bb);
                }
                case 4: {
                    return OFExperimenterVer12.READER.readFrom(bb);
                }
                case 3: {
                    return OFEchoReplyVer12.READER.readFrom(bb);
                }
                case 2: {
                    return OFEchoRequestVer12.READER.readFrom(bb);
                }
                case 6: {
                    return OFFeaturesReplyVer12.READER.readFrom(bb);
                }
                case 5: {
                    return OFFeaturesRequestVer12.READER.readFrom(bb);
                }
                case 14: {
                    return OFFlowModVer12.READER.readFrom(bb);
                }
                case 11: {
                    return OFFlowRemovedVer12.READER.readFrom(bb);
                }
                case 8: {
                    return OFGetConfigReplyVer12.READER.readFrom(bb);
                }
                case 7: {
                    return OFGetConfigRequestVer12.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloVer12.READER.readFrom(bb);
                }
                case 10: {
                    return OFPacketInVer12.READER.readFrom(bb);
                }
                case 13: {
                    return OFPacketOutVer12.READER.readFrom(bb);
                }
                case 16: {
                    return OFPortModVer12.READER.readFrom(bb);
                }
                case 12: {
                    return OFPortStatusVer12.READER.readFrom(bb);
                }
                case 23: {
                    return OFQueueGetConfigReplyVer12.READER.readFrom(bb);
                }
                case 22: {
                    return OFQueueGetConfigRequestVer12.READER.readFrom(bb);
                }
                case 9: {
                    return OFSetConfigVer12.READER.readFrom(bb);
                }
                case 17: {
                    return OFTableModVer12.READER.readFrom(bb);
                }
                case 15: {
                    return OFGroupModVer12.READER.readFrom(bb);
                }
                case 25: {
                    return OFRoleReplyVer12.READER.readFrom(bb);
                }
                case 24: {
                    return OFRoleRequestVer12.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFMessageVer12: " + type);
        }
    }
}

