/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPacketOut;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver11.OFActionVer11;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPacketOutVer11
implements OFPacketOut {
    private static final Logger logger = LoggerFactory.getLogger(OFPacketOutVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final OFBufferId DEFAULT_BUFFER_ID = OFBufferId.NO_BUFFER;
    private static final OFPort DEFAULT_IN_PORT = OFPort.ANY;
    private static final List<OFAction> DEFAULT_ACTIONS = ImmutableList.of();
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final OFBufferId bufferId;
    private final OFPort inPort;
    private final List<OFAction> actions;
    private final byte[] data;
    static final OFPacketOutVer11 DEFAULT = new OFPacketOutVer11(0L, DEFAULT_BUFFER_ID, DEFAULT_IN_PORT, DEFAULT_ACTIONS, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFPacketOutVer11Funnel FUNNEL = new OFPacketOutVer11Funnel();
    static final Writer WRITER = new Writer();

    OFPacketOutVer11(long xid, OFBufferId bufferId, OFPort inPort, List<OFAction> actions, byte[] data) {
        if (bufferId == null) {
            throw new NullPointerException("OFPacketOutVer11: property bufferId cannot be null");
        }
        if (inPort == null) {
            throw new NullPointerException("OFPacketOutVer11: property inPort cannot be null");
        }
        if (actions == null) {
            throw new NullPointerException("OFPacketOutVer11: property actions cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFPacketOutVer11: property data cannot be null");
        }
        this.xid = xid;
        this.bufferId = bufferId;
        this.inPort = inPort;
        this.actions = actions;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.PACKET_OUT;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFBufferId getBufferId() {
        return this.bufferId;
    }

    @Override
    public OFPort getInPort() {
        return this.inPort;
    }

    @Override
    public List<OFAction> getActions() {
        return this.actions;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Match getMatch() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property match not supported in version 1.1");
    }

    @Override
    public OFPacketOut.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPacketOutVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("bufferId=").append(this.bufferId);
        b.append(", ");
        b.append("inPort=").append(this.inPort);
        b.append(", ");
        b.append("actions=").append(this.actions);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketOutVer11 other = (OFPacketOutVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.inPort == null ? other.inPort != null : !this.inPort.equals(other.inPort)) {
            return false;
        }
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketOutVer11 other = (OFPacketOutVer11)obj;
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.inPort == null ? other.inPort != null : !this.inPort.equals(other.inPort)) {
            return false;
        }
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + (this.inPort == null ? 0 : this.inPort.hashCode());
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + (this.inPort == null ? 0 : this.inPort.hashCode());
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPacketOutVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPacketOutVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(13);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(message.bufferId.getInt());
            message.inPort.write4Bytes(bb);
            int actionsLenIndex = bb.writerIndex();
            bb.writeShort(0);
            bb.writeZero(6);
            int actionsStartIndex = bb.writerIndex();
            ChannelUtils.writeList(bb, message.actions);
            int actionsLength = bb.writerIndex() - actionsStartIndex;
            bb.setShort(actionsLenIndex, actionsLength);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPacketOutVer11Funnel
    implements Funnel<OFPacketOutVer11> {
        private static final long serialVersionUID = 1L;

        OFPacketOutVer11Funnel() {
        }

        public void funnel(OFPacketOutVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)13);
            sink.putLong(message.xid);
            message.bufferId.putTo(sink);
            message.inPort.putTo(sink);
            FunnelUtils.putList(message.actions, sink);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFPacketOut> {
        Reader() {
        }

        @Override
        public OFPacketOut readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 13) {
                throw new OFParseError("Wrong type: Expected=OFType.PACKET_OUT(13), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFBufferId bufferId = OFBufferId.of(bb.readInt());
            OFPort inPort = OFPort.read4Bytes(bb);
            int actionsLen = U16.f(bb.readShort());
            bb.skipBytes(6);
            List<OFAction> actions = ChannelUtils.readList(bb, actionsLen, OFActionVer11.READER);
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPacketOutVer11 packetOutVer11 = new OFPacketOutVer11(xid, bufferId, inPort, actions, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)packetOutVer11);
            }
            return packetOutVer11;
        }
    }

    static class Builder
    implements OFPacketOut.Builder {
        private boolean xidSet;
        private long xid;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean actionsSet;
        private List<OFAction> actions;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.PACKET_OUT;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPacketOut.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFPacketOut.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFPacketOut.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFPacketOut.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPacketOut.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public Match getMatch() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.1");
        }

        @Override
        public OFPacketOut.Builder setMatch(Match match) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.1");
        }

        @Override
        public OFPacketOut build() {
            byte[] data;
            List<OFAction> actions;
            OFPort inPort;
            OFBufferId bufferId;
            long xid = this.xidSet ? this.xid : 0L;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : DEFAULT_BUFFER_ID;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : DEFAULT_IN_PORT;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            List<OFAction> list = actions = this.actionsSet ? this.actions : DEFAULT_ACTIONS;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPacketOutVer11(xid, bufferId, inPort, actions, data);
        }
    }

    static class BuilderWithParent
    implements OFPacketOut.Builder {
        final OFPacketOutVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean actionsSet;
        private List<OFAction> actions;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFPacketOutVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.PACKET_OUT;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPacketOut.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFPacketOut.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFPacketOut.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFPacketOut.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPacketOut.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public Match getMatch() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.1");
        }

        @Override
        public OFPacketOut.Builder setMatch(Match match) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.1");
        }

        @Override
        public OFPacketOut build() {
            byte[] data;
            List actions;
            OFPort inPort;
            OFBufferId bufferId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : this.parentMessage.bufferId;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : this.parentMessage.inPort;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            List list = actions = this.actionsSet ? this.actions : this.parentMessage.actions;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPacketOutVer11(xid, bufferId, inPort, actions, data);
        }
    }
}

