/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.ver11.OFInstructionApplyActionsVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFInstructionClearActionsVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFInstructionExperimenterVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFInstructionGotoTableVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFInstructionWriteActionsVer11;
import org.projectfloodlight.openflow.protocol.ver11.OFInstructionWriteMetadataVer11;

abstract class OFInstructionVer11 {
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFInstructionVer11() {
    }

    static class Reader
    implements OFMessageReader<OFInstruction> {
        Reader() {
        }

        @Override
        public OFInstruction readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            bb.readerIndex(start);
            switch (type) {
                case 4: {
                    return OFInstructionApplyActionsVer11.READER.readFrom(bb);
                }
                case 5: {
                    return OFInstructionClearActionsVer11.READER.readFrom(bb);
                }
                case -1: {
                    return OFInstructionExperimenterVer11.READER.readFrom(bb);
                }
                case 1: {
                    return OFInstructionGotoTableVer11.READER.readFrom(bb);
                }
                case 3: {
                    return OFInstructionWriteActionsVer11.READER.readFrom(bb);
                }
                case 2: {
                    return OFInstructionWriteMetadataVer11.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFInstructionVer11: " + type);
        }
    }
}

