/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPortState;

public class OFPortStateSerializerVer10 {
    public static final int LINK_DOWN_VAL = 1;
    public static final int STP_LISTEN_VAL = 0;
    public static final int STP_LEARN_VAL = 256;
    public static final int STP_FORWARD_VAL = 512;
    public static final int STP_BLOCK_VAL = 768;
    public static final int STP_MASK_VAL = 768;

    public static Set<OFPortState> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFPortStateSerializerVer10.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFPortState> set) {
        bb.writeInt(OFPortStateSerializerVer10.toWireValue(set));
    }

    public static void putTo(Set<OFPortState> set, PrimitiveSink sink) {
        sink.putInt(OFPortStateSerializerVer10.toWireValue(set));
    }

    public static Set<OFPortState> ofWireValue(int val) {
        EnumSet<OFPortState> set = EnumSet.noneOf(OFPortState.class);
        if ((val & 1) != 0) {
            set.add(OFPortState.LINK_DOWN);
        }
        if ((val & 0x300) == 0) {
            set.add(OFPortState.STP_LISTEN);
        } else if ((val & 0x300) == 256) {
            set.add(OFPortState.STP_LEARN);
        } else if ((val & 0x300) == 512) {
            set.add(OFPortState.STP_FORWARD);
        } else if ((val & 0x300) == 768) {
            set.add(OFPortState.STP_BLOCK);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFPortState> set) {
        int wireValue = 0;
        block7: for (OFPortState e : set) {
            switch (e) {
                case LINK_DOWN: {
                    wireValue |= 1;
                    continue block7;
                }
                case STP_LISTEN: {
                    wireValue |= 0;
                    continue block7;
                }
                case STP_LEARN: {
                    wireValue |= 0x100;
                    continue block7;
                }
                case STP_FORWARD: {
                    wireValue |= 0x200;
                    continue block7;
                }
                case STP_BLOCK: {
                    wireValue |= 0x300;
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFPortState in version 1.0: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

