/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHybridGetReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnHybridGetReplyVer10
implements OFBsnHybridGetReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnHybridGetReplyVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_HYBRID_ENABLE = 0;
    private static final int DEFAULT_HYBRID_VERSION = 0;
    private final long xid;
    private final short hybridEnable;
    private final int hybridVersion;
    static final OFBsnHybridGetReplyVer10 DEFAULT = new OFBsnHybridGetReplyVer10(0L, 0, 0);
    static final Reader READER = new Reader();
    static final OFBsnHybridGetReplyVer10Funnel FUNNEL = new OFBsnHybridGetReplyVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBsnHybridGetReplyVer10(long xid, short hybridEnable, int hybridVersion) {
        this.xid = xid;
        this.hybridEnable = hybridEnable;
        this.hybridVersion = hybridVersion;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 28L;
    }

    @Override
    public short getHybridEnable() {
        return this.hybridEnable;
    }

    @Override
    public int getHybridVersion() {
        return this.hybridVersion;
    }

    @Override
    public OFBsnHybridGetReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnHybridGetReplyVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("hybridEnable=").append(this.hybridEnable);
        b.append(", ");
        b.append("hybridVersion=").append(this.hybridVersion);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnHybridGetReplyVer10 other = (OFBsnHybridGetReplyVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.hybridEnable != other.hybridEnable) {
            return false;
        }
        return this.hybridVersion == other.hybridVersion;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnHybridGetReplyVer10 other = (OFBsnHybridGetReplyVer10)obj;
        if (this.hybridEnable != other.hybridEnable) {
            return false;
        }
        return this.hybridVersion == other.hybridVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.hybridEnable;
        result = 31 * result + this.hybridVersion;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hybridEnable;
        result = 31 * result + this.hybridVersion;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnHybridGetReplyVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnHybridGetReplyVer10 message) {
            bb.writeByte(1);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(28);
            bb.writeByte((int)U8.t(message.hybridEnable));
            bb.writeZero(1);
            bb.writeShort((int)U16.t(message.hybridVersion));
            bb.writeZero(4);
        }
    }

    static class OFBsnHybridGetReplyVer10Funnel
    implements Funnel<OFBsnHybridGetReplyVer10> {
        private static final long serialVersionUID = 1L;

        OFBsnHybridGetReplyVer10Funnel() {
        }

        public void funnel(OFBsnHybridGetReplyVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(28);
            sink.putShort(message.hybridEnable);
            sink.putInt(message.hybridVersion);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnHybridGetReply> {
        Reader() {
        }

        @Override
        public OFBsnHybridGetReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 28) {
                throw new OFParseError("Wrong subtype: Expected=0x1cL(0x1cL), got=" + subtype);
            }
            short hybridEnable = U8.f(bb.readByte());
            bb.skipBytes(1);
            int hybridVersion = U16.f(bb.readShort());
            bb.skipBytes(4);
            OFBsnHybridGetReplyVer10 bsnHybridGetReplyVer10 = new OFBsnHybridGetReplyVer10(xid, hybridEnable, hybridVersion);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnHybridGetReplyVer10);
            }
            return bsnHybridGetReplyVer10;
        }
    }

    static class Builder
    implements OFBsnHybridGetReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean hybridEnableSet;
        private short hybridEnable;
        private boolean hybridVersionSet;
        private int hybridVersion;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnHybridGetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 28L;
        }

        @Override
        public short getHybridEnable() {
            return this.hybridEnable;
        }

        @Override
        public OFBsnHybridGetReply.Builder setHybridEnable(short hybridEnable) {
            this.hybridEnable = hybridEnable;
            this.hybridEnableSet = true;
            return this;
        }

        @Override
        public int getHybridVersion() {
            return this.hybridVersion;
        }

        @Override
        public OFBsnHybridGetReply.Builder setHybridVersion(int hybridVersion) {
            this.hybridVersion = hybridVersion;
            this.hybridVersionSet = true;
            return this;
        }

        @Override
        public OFBsnHybridGetReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            short hybridEnable = this.hybridEnableSet ? this.hybridEnable : (short)0;
            int hybridVersion = this.hybridVersionSet ? this.hybridVersion : 0;
            return new OFBsnHybridGetReplyVer10(xid, hybridEnable, hybridVersion);
        }
    }

    static class BuilderWithParent
    implements OFBsnHybridGetReply.Builder {
        final OFBsnHybridGetReplyVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean hybridEnableSet;
        private short hybridEnable;
        private boolean hybridVersionSet;
        private int hybridVersion;

        BuilderWithParent(OFBsnHybridGetReplyVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnHybridGetReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 28L;
        }

        @Override
        public short getHybridEnable() {
            return this.hybridEnable;
        }

        @Override
        public OFBsnHybridGetReply.Builder setHybridEnable(short hybridEnable) {
            this.hybridEnable = hybridEnable;
            this.hybridEnableSet = true;
            return this;
        }

        @Override
        public int getHybridVersion() {
            return this.hybridVersion;
        }

        @Override
        public OFBsnHybridGetReply.Builder setHybridVersion(int hybridVersion) {
            this.hybridVersion = hybridVersion;
            this.hybridVersionSet = true;
            return this;
        }

        @Override
        public OFBsnHybridGetReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short hybridEnable = this.hybridEnableSet ? this.hybridEnable : this.parentMessage.hybridEnable;
            int hybridVersion = this.hybridVersionSet ? this.hybridVersion : this.parentMessage.hybridVersion;
            return new OFBsnHybridGetReplyVer10(xid, hybridEnable, hybridVersion);
        }
    }
}

