/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFQueueDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFQueueDescStatsReplyVer15;

public class OFQueueDescStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] QUEUE_DESC_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 40, 18, 52, 86, 120, 0, 15, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 24, 0, 0, 0, 0, 0, 0, 0, 1, 0, 8, 0, 1, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFQueueDescStatsReply.Builder builder = this.factory.buildQueueDescStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildQueueDesc().setPortNo(1L).setQueueId(1L).setProperties((List)ImmutableList.of((Object)this.factory.buildQueueDescPropMinRate().setRate(1).build())).build())).build();
        OFQueueDescStatsReply queueDescStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        queueDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)QUEUE_DESC_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFQueueDescStatsReply.Builder builder = this.factory.buildQueueDescStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildQueueDesc().setPortNo(1L).setQueueId(1L).setProperties((List)ImmutableList.of((Object)this.factory.buildQueueDescPropMinRate().setRate(1).build())).build())).build();
        OFQueueDescStatsReply queueDescStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])QUEUE_DESC_STATS_REPLY_SERIALIZED);
        OFQueueDescStatsReply queueDescStatsReplyRead = OFQueueDescStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)QUEUE_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)queueDescStatsReplyBuilt, (Object)queueDescStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])QUEUE_DESC_STATS_REPLY_SERIALIZED);
        OFQueueDescStatsReply queueDescStatsReply = OFQueueDescStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)QUEUE_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        queueDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)QUEUE_DESC_STATS_REPLY_SERIALIZED));
    }
}

