/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortStatsReplyVer15;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U64;

public class OFPortStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] PORT_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, -120, 18, 52, 86, 120, 0, 4, 0, 1, 0, 0, 0, 0, 0, 120, 0, 0, 0, 0, 0, 1, 0, 0, 0, 3, -78, -48, 94, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 0, 29};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPortStatsReply.Builder builder = this.factory.buildPortStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildPortStatsEntry().setPortNo(OFPort.of((int)1)).setDurationSec(3L).setDurationNsec(3000000000L).setRxPackets(U64.of((long)10L)).setTxPackets(U64.of((long)7L)).setRxBytes(U64.of((long)10L)).setTxBytes(U64.of((long)7L)).setRxDropped(U64.of((long)2L)).setTxDropped(U64.of((long)1L)).setRxErrors(U64.of((long)1L)).setTxErrors(U64.of((long)1L)).setProperties((List)ImmutableList.of((Object)this.factory.buildPortStatsPropEthernet().setRxFrameErr(U64.of((long)26L)).setRxOverErr(U64.of((long)27L)).setRxCrcErr(U64.of((long)28L)).setCollisions(U64.of((long)29L)).build())).build())).build();
        OFPortStatsReply portStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        portStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPortStatsReply.Builder builder = this.factory.buildPortStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildPortStatsEntry().setPortNo(OFPort.of((int)1)).setDurationSec(3L).setDurationNsec(3000000000L).setRxPackets(U64.of((long)10L)).setTxPackets(U64.of((long)7L)).setRxBytes(U64.of((long)10L)).setTxBytes(U64.of((long)7L)).setRxDropped(U64.of((long)2L)).setTxDropped(U64.of((long)1L)).setRxErrors(U64.of((long)1L)).setTxErrors(U64.of((long)1L)).setProperties((List)ImmutableList.of((Object)this.factory.buildPortStatsPropEthernet().setRxFrameErr(U64.of((long)26L)).setRxOverErr(U64.of((long)27L)).setRxCrcErr(U64.of((long)28L)).setCollisions(U64.of((long)29L)).build())).build())).build();
        OFPortStatsReply portStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_STATS_REPLY_SERIALIZED);
        OFPortStatsReply portStatsReplyRead = OFPortStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)portStatsReplyBuilt, (Object)portStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_STATS_REPLY_SERIALIZED);
        OFPortStatsReply portStatsReply = OFPortStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_STATS_REPLY_SERIALIZED));
    }
}

