/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class VlanPcp
implements OFValueType<VlanPcp> {
    private static final byte VALIDATION_MASK = 7;
    private static final byte NONE_VAL = 0;
    static final int LENGTH = 1;
    private final byte pcp;
    public static final VlanPcp NONE = new VlanPcp(0);
    public static final VlanPcp NO_MASK = new VlanPcp(-1);
    public static final VlanPcp FULL_MASK = VlanPcp.of((byte)0);

    private VlanPcp(byte pcp) {
        this.pcp = pcp;
    }

    public static VlanPcp of(byte pcp) {
        if ((pcp & 7) != pcp) {
            throw new IllegalArgumentException("Illegal VLAN PCP value: " + pcp);
        }
        return new VlanPcp(pcp);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VlanPcp)) {
            return false;
        }
        VlanPcp other = (VlanPcp)obj;
        return other.pcp == this.pcp;
    }

    public int hashCode() {
        int prime = 20173;
        return this.pcp * prime;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.pcp);
    }

    public byte getValue() {
        return this.pcp;
    }

    @Override
    public int getLength() {
        return 1;
    }

    public void writeByte(ByteBuf c) {
        c.writeByte((int)this.pcp);
    }

    public static VlanPcp readByte(ByteBuf c) throws OFParseError {
        return VlanPcp.of((byte)(c.readUnsignedByte() & 0xFF));
    }

    @Override
    public VlanPcp applyMask(VlanPcp mask) {
        return VlanPcp.of((byte)(this.pcp & mask.pcp));
    }

    @Override
    public int compareTo(VlanPcp o) {
        return UnsignedBytes.compare((byte)this.pcp, (byte)o.pcp);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putByte(this.pcp);
    }
}

