/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.annotations.Immutable;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

@Immutable
public class OFGroup
implements OFValueType<OFGroup> {
    static final int LENGTH = 4;
    private static final int ZERO_VAL = 0;
    private static final int MAX_VAL = -256;
    private static final int ALL_VAL = -4;
    private static final int ANY_VAL = -1;
    public static final OFGroup MAX = new NamedGroup(-256, "max");
    public static final OFGroup ALL = new NamedGroup(-4, "all");
    public static final OFGroup ANY = new NamedGroup(-1, "any");
    public static final OFGroup ZERO = new OFGroup(0);
    public static final OFGroup NO_MASK = ANY;
    public static final OFGroup FULL_MASK = ZERO;
    private final int groupNumber;

    private OFGroup(int portNumber) {
        this.groupNumber = portNumber;
    }

    public static OFGroup of(int groupNumber) {
        switch (groupNumber) {
            case 0: {
                return ZERO;
            }
            case -256: {
                return MAX;
            }
            case -4: {
                return ALL;
            }
            case -1: {
                return ANY;
            }
        }
        if (UnsignedInts.compare((int)groupNumber, (int)-256) > 0) {
            throw new IllegalArgumentException("Unknown special group number: " + groupNumber);
        }
        return new OFGroup(groupNumber);
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public String toString() {
        return UnsignedInts.toString((int)this.groupNumber);
    }

    @Override
    public int getLength() {
        return 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OFGroup)) {
            return false;
        }
        OFGroup other = (OFGroup)obj;
        return other.groupNumber == this.groupNumber;
    }

    public int hashCode() {
        int prime = 53;
        int result = 1;
        result = 53 * result + this.groupNumber;
        return result;
    }

    public void write4Bytes(ByteBuf c) {
        c.writeInt(this.groupNumber);
    }

    public static OFGroup read4Bytes(ByteBuf c) throws OFParseError {
        return OFGroup.of(c.readInt());
    }

    @Override
    public OFGroup applyMask(OFGroup mask) {
        return OFGroup.of(this.groupNumber & mask.groupNumber);
    }

    @Override
    public int compareTo(OFGroup o) {
        return UnsignedInts.compare((int)this.groupNumber, (int)o.groupNumber);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.groupNumber);
    }

    static class NamedGroup
    extends OFGroup {
        private final String name;

        NamedGroup(int portNo, String name) {
            super(portNo);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

