/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import org.projectfloodlight.openflow.annotations.Immutable;
import org.projectfloodlight.openflow.types.PrimitiveSinkable;
import org.projectfloodlight.openflow.types.U32;

@Immutable
public class OFBufferId
implements Comparable<OFBufferId>,
PrimitiveSinkable {
    public static final OFBufferId NO_BUFFER = new OFBufferId(-1);
    private final int rawValue;

    private OFBufferId(int rawValue) {
        this.rawValue = rawValue;
    }

    public static OFBufferId of(int rawValue) {
        if (rawValue == NO_BUFFER.getInt()) {
            return NO_BUFFER;
        }
        return new OFBufferId(rawValue);
    }

    public int getInt() {
        return this.rawValue;
    }

    public String toString() {
        return Long.toString(U32.f(this.rawValue));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rawValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBufferId other = (OFBufferId)obj;
        return this.rawValue == other.rawValue;
    }

    @Override
    public int compareTo(OFBufferId o) {
        return UnsignedInts.compare((int)this.rawValue, (int)o.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.rawValue);
    }
}

