/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.Immutable;
import org.projectfloodlight.openflow.types.OFValueType;

@Immutable
public class LagId
implements OFValueType<LagId> {
    static final int LENGTH = 4;
    private final int rawValue;
    private static final int NONE_VAL = 0;
    public static final LagId NONE = new LagId(0);
    private static final int NO_MASK_VAL = -1;
    public static final LagId NO_MASK = new LagId(-1);
    public static final LagId FULL_MASK = NONE;

    private LagId(int rawValue) {
        this.rawValue = rawValue;
    }

    public static LagId of(int raw) {
        if (raw == 0) {
            return NONE;
        }
        if (raw == -1) {
            return NO_MASK;
        }
        return new LagId(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public int getLength() {
        return 4;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rawValue;
        return result;
    }

    public String toString() {
        return Integer.toString(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LagId other = (LagId)obj;
        return this.rawValue == other.rawValue;
    }

    public void write4Bytes(ByteBuf c) {
        c.writeInt(this.rawValue);
    }

    public static LagId read4Bytes(ByteBuf c) {
        return LagId.of(c.readInt());
    }

    @Override
    public int compareTo(LagId o) {
        return UnsignedInts.compare((int)this.rawValue, (int)o.rawValue);
    }

    @Override
    public LagId applyMask(LagId mask) {
        return LagId.of(this.rawValue & mask.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.rawValue);
    }
}

