/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.Immutable;
import org.projectfloodlight.openflow.types.OFValueType;

@Immutable
public class BundleId
implements OFValueType<BundleId> {
    static final int LENGTH = 4;
    private static final int NONE_VAL = 0;
    public static final BundleId NONE = new BundleId(0);
    private static final int NO_MASK_VAL = -1;
    public static final BundleId NO_MASK = new BundleId(-1);
    public static final BundleId FULL_MASK = NONE;
    private final int rawValue;

    private BundleId(int rawValue) {
        this.rawValue = rawValue;
    }

    public static BundleId of(int raw) {
        if (raw == 0) {
            return NONE;
        }
        if (raw == -1) {
            return NO_MASK;
        }
        return new BundleId(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public int getLength() {
        return 4;
    }

    public String toString() {
        return UnsignedInts.toString((int)this.rawValue);
    }

    @Override
    public BundleId applyMask(BundleId mask) {
        return BundleId.of(this.rawValue & mask.rawValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rawValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleId other = (BundleId)obj;
        return this.rawValue == other.rawValue;
    }

    public void write4Bytes(ByteBuf c) {
        c.writeInt(this.rawValue);
    }

    public static BundleId read4Bytes(ByteBuf c) {
        return BundleId.of(c.readInt());
    }

    @Override
    public int compareTo(BundleId o) {
        return UnsignedInts.compare((int)this.rawValue, (int)this.rawValue);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.rawValue);
    }
}

