/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableDesc;
import org.projectfloodlight.openflow.protocol.OFTableReason;
import org.projectfloodlight.openflow.protocol.OFTableStatus;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFTableDescVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableReasonSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableStatusVer15
implements OFTableStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFTableStatusVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    private final OFTableReason reason;
    private final OFTableDesc table;
    static final Reader READER = new Reader();
    static final OFTableStatusVer15Funnel FUNNEL = new OFTableStatusVer15Funnel();
    static final Writer WRITER = new Writer();

    OFTableStatusVer15(long xid, OFTableReason reason, OFTableDesc table) {
        if (reason == null) {
            throw new NullPointerException("OFTableStatusVer15: property reason cannot be null");
        }
        if (table == null) {
            throw new NullPointerException("OFTableStatusVer15: property table cannot be null");
        }
        this.xid = xid;
        this.reason = reason;
        this.table = table;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.TABLE_STATUS;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFTableReason getReason() {
        return this.reason;
    }

    @Override
    public OFTableDesc getTable() {
        return this.table;
    }

    @Override
    public long getRole() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property role not supported in version 1.5");
    }

    @Override
    public OFTableStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableStatusVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("table=").append(this.table);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableStatusVer15 other = (OFTableStatusVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableStatusVer15 other = (OFTableStatusVer15)obj;
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableStatusVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableStatusVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(31);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            OFTableReasonSerializerVer15.writeTo(bb, message.reason);
            bb.writeZero(7);
            message.table.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableStatusVer15Funnel
    implements Funnel<OFTableStatusVer15> {
        private static final long serialVersionUID = 1L;

        OFTableStatusVer15Funnel() {
        }

        public void funnel(OFTableStatusVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)31);
            sink.putLong(message.xid);
            OFTableReasonSerializerVer15.putTo(message.reason, sink);
            message.table.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableStatus> {
        Reader() {
        }

        @Override
        public OFTableStatus readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 31) {
                throw new OFParseError("Wrong type: Expected=OFType.TABLE_STATUS(31), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFTableReason reason = OFTableReasonSerializerVer15.readFrom(bb);
            bb.skipBytes(7);
            OFTableDesc table = OFTableDescVer15.READER.readFrom(bb);
            OFTableStatusVer15 tableStatusVer15 = new OFTableStatusVer15(xid, reason, table);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableStatusVer15);
            }
            return tableStatusVer15;
        }
    }

    static class Builder
    implements OFTableStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFTableReason reason;
        private boolean tableSet;
        private OFTableDesc table;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.TABLE_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFTableReason getReason() {
            return this.reason;
        }

        @Override
        public OFTableStatus.Builder setReason(OFTableReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFTableDesc getTable() {
            return this.table;
        }

        @Override
        public OFTableStatus.Builder setTable(OFTableDesc table) {
            this.table = table;
            this.tableSet = true;
            return this;
        }

        @Override
        public long getRole() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
        }

        @Override
        public OFTableStatus.Builder setRole(long role) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
        }

        @Override
        public OFTableStatus build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            if (!this.tableSet) {
                throw new IllegalStateException("Property table doesn't have default value -- must be set");
            }
            if (this.table == null) {
                throw new NullPointerException("Property table must not be null");
            }
            return new OFTableStatusVer15(xid, this.reason, this.table);
        }
    }

    static class BuilderWithParent
    implements OFTableStatus.Builder {
        final OFTableStatusVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean reasonSet;
        private OFTableReason reason;
        private boolean tableSet;
        private OFTableDesc table;

        BuilderWithParent(OFTableStatusVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.TABLE_STATUS;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFTableStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFTableReason getReason() {
            return this.reason;
        }

        @Override
        public OFTableStatus.Builder setReason(OFTableReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public OFTableDesc getTable() {
            return this.table;
        }

        @Override
        public OFTableStatus.Builder setTable(OFTableDesc table) {
            this.table = table;
            this.tableSet = true;
            return this;
        }

        @Override
        public long getRole() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
        }

        @Override
        public OFTableStatus.Builder setRole(long role) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
        }

        @Override
        public OFTableStatus build() {
            OFTableDesc table;
            OFTableReason reason;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFTableReason oFTableReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            OFTableDesc oFTableDesc = table = this.tableSet ? this.table : this.parentMessage.table;
            if (table == null) {
                throw new NullPointerException("Property table must not be null");
            }
            return new OFTableStatusVer15(xid, reason, table);
        }
    }
}

