/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableConfig;
import org.projectfloodlight.openflow.protocol.OFTableFeatureFlag;
import org.projectfloodlight.openflow.protocol.OFTableFeatureProp;
import org.projectfloodlight.openflow.protocol.OFTableFeatures;
import org.projectfloodlight.openflow.protocol.OFTableFeaturesCommand;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFTableConfigSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableFeatureFlagSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableFeaturePropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableFeaturesCommandSerializerVer15;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturesVer15
implements OFTableFeatures {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturesVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 64;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final Set<OFTableFeatureFlag> DEFAULT_FEATURES = ImmutableSet.of();
    private static final String DEFAULT_NAME = "";
    private static final U64 DEFAULT_METADATA_MATCH = U64.ZERO;
    private static final U64 DEFAULT_METADATA_WRITE = U64.ZERO;
    private static final Set<OFTableConfig> DEFAULT_CAPABILITIES = ImmutableSet.of();
    private static final long DEFAULT_MAX_ENTRIES = 0L;
    private static final List<OFTableFeatureProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final TableId tableId;
    private final OFTableFeaturesCommand command;
    private final Set<OFTableFeatureFlag> features;
    private final String name;
    private final U64 metadataMatch;
    private final U64 metadataWrite;
    private final Set<OFTableConfig> capabilities;
    private final long maxEntries;
    private final List<OFTableFeatureProp> properties;
    static final Reader READER = new Reader();
    static final OFTableFeaturesVer15Funnel FUNNEL = new OFTableFeaturesVer15Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturesVer15(TableId tableId, OFTableFeaturesCommand command, Set<OFTableFeatureFlag> features, String name, U64 metadataMatch, U64 metadataWrite, Set<OFTableConfig> capabilities, long maxEntries, List<OFTableFeatureProp> properties) {
        if (tableId == null) {
            throw new NullPointerException("OFTableFeaturesVer15: property tableId cannot be null");
        }
        if (command == null) {
            throw new NullPointerException("OFTableFeaturesVer15: property command cannot be null");
        }
        if (features == null) {
            throw new NullPointerException("OFTableFeaturesVer15: property features cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFTableFeaturesVer15: property name cannot be null");
        }
        if (metadataMatch == null) {
            throw new NullPointerException("OFTableFeaturesVer15: property metadataMatch cannot be null");
        }
        if (metadataWrite == null) {
            throw new NullPointerException("OFTableFeaturesVer15: property metadataWrite cannot be null");
        }
        if (capabilities == null) {
            throw new NullPointerException("OFTableFeaturesVer15: property capabilities cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFTableFeaturesVer15: property properties cannot be null");
        }
        this.tableId = tableId;
        this.command = command;
        this.features = features;
        this.name = name;
        this.metadataMatch = metadataMatch;
        this.metadataWrite = metadataWrite;
        this.capabilities = capabilities;
        this.maxEntries = maxEntries;
        this.properties = properties;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public U64 getMetadataMatch() {
        return this.metadataMatch;
    }

    @Override
    public U64 getMetadataWrite() {
        return this.metadataWrite;
    }

    @Override
    public long getConfig() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property config not supported in version 1.5");
    }

    @Override
    public long getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public List<OFTableFeatureProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFTableFeaturesCommand getCommand() {
        return this.command;
    }

    @Override
    public Set<OFTableFeatureFlag> getFeatures() {
        return this.features;
    }

    @Override
    public Set<OFTableConfig> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFTableFeatures.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturesVer15(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("command=").append((Object)this.command);
        b.append(", ");
        b.append("features=").append(this.features);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("metadataMatch=").append(this.metadataMatch);
        b.append(", ");
        b.append("metadataWrite=").append(this.metadataWrite);
        b.append(", ");
        b.append("capabilities=").append(this.capabilities);
        b.append(", ");
        b.append("maxEntries=").append(this.maxEntries);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturesVer15 other = (OFTableFeaturesVer15)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.command == null ? other.command != null : !this.command.equals((Object)other.command)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.metadataMatch == null ? other.metadataMatch != null : !this.metadataMatch.equals(other.metadataMatch)) {
            return false;
        }
        if (this.metadataWrite == null ? other.metadataWrite != null : !this.metadataWrite.equals(other.metadataWrite)) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        if (this.maxEntries != other.maxEntries) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadataMatch == null ? 0 : this.metadataMatch.hashCode());
        result = 31 * result + (this.metadataWrite == null ? 0 : this.metadataWrite.hashCode());
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * (int)(this.maxEntries ^ this.maxEntries >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturesVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturesVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.tableId.writeByte(bb);
            OFTableFeaturesCommandSerializerVer15.writeTo(bb, message.command);
            OFTableFeatureFlagSerializerVer15.writeTo(bb, message.features);
            ChannelUtils.writeFixedLengthString(bb, message.name, 32);
            bb.writeLong(message.metadataMatch.getValue());
            bb.writeLong(message.metadataWrite.getValue());
            OFTableConfigSerializerVer15.writeTo(bb, message.capabilities);
            bb.writeInt(U32.t(message.maxEntries));
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturesVer15Funnel
    implements Funnel<OFTableFeaturesVer15> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturesVer15Funnel() {
        }

        public void funnel(OFTableFeaturesVer15 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            OFTableFeaturesCommandSerializerVer15.putTo(message.command, sink);
            OFTableFeatureFlagSerializerVer15.putTo(message.features, sink);
            sink.putUnencodedChars((CharSequence)message.name);
            message.metadataMatch.putTo(sink);
            message.metadataWrite.putTo(sink);
            OFTableConfigSerializerVer15.putTo(message.capabilities, sink);
            sink.putLong(message.maxEntries);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeatures> {
        Reader() {
        }

        @Override
        public OFTableFeatures readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 64) {
                throw new OFParseError("Wrong length: Expected to be >= 64, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TableId tableId = TableId.readByte(bb);
            OFTableFeaturesCommand command = OFTableFeaturesCommandSerializerVer15.readFrom(bb);
            Set<OFTableFeatureFlag> features = OFTableFeatureFlagSerializerVer15.readFrom(bb);
            String name = ChannelUtils.readFixedLengthString(bb, 32);
            U64 metadataMatch = U64.ofRaw(bb.readLong());
            U64 metadataWrite = U64.ofRaw(bb.readLong());
            Set<OFTableConfig> capabilities = OFTableConfigSerializerVer15.readFrom(bb);
            long maxEntries = U32.f(bb.readInt());
            List<OFTableFeatureProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFTableFeaturePropVer15.READER);
            OFTableFeaturesVer15 tableFeaturesVer15 = new OFTableFeaturesVer15(tableId, command, features, name, metadataMatch, metadataWrite, capabilities, maxEntries, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturesVer15);
            }
            return tableFeaturesVer15;
        }
    }

    static class Builder
    implements OFTableFeatures.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean commandSet;
        private OFTableFeaturesCommand command;
        private boolean featuresSet;
        private Set<OFTableFeatureFlag> features;
        private boolean nameSet;
        private String name;
        private boolean metadataMatchSet;
        private U64 metadataMatch;
        private boolean metadataWriteSet;
        private U64 metadataWrite;
        private boolean capabilitiesSet;
        private Set<OFTableConfig> capabilities;
        private boolean maxEntriesSet;
        private long maxEntries;
        private boolean propertiesSet;
        private List<OFTableFeatureProp> properties;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableFeatures.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFTableFeatures.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMatch() {
            return this.metadataMatch;
        }

        @Override
        public OFTableFeatures.Builder setMetadataMatch(U64 metadataMatch) {
            this.metadataMatch = metadataMatch;
            this.metadataMatchSet = true;
            return this;
        }

        @Override
        public U64 getMetadataWrite() {
            return this.metadataWrite;
        }

        @Override
        public OFTableFeatures.Builder setMetadataWrite(U64 metadataWrite) {
            this.metadataWrite = metadataWrite;
            this.metadataWriteSet = true;
            return this;
        }

        @Override
        public long getConfig() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property config not supported in version 1.5");
        }

        @Override
        public OFTableFeatures.Builder setConfig(long config) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property config not supported in version 1.5");
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFTableFeatures.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public List<OFTableFeatureProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFTableFeatures.Builder setProperties(List<OFTableFeatureProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFTableFeaturesCommand getCommand() {
            return this.command;
        }

        @Override
        public OFTableFeatures.Builder setCommand(OFTableFeaturesCommand command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public Set<OFTableFeatureFlag> getFeatures() {
            return this.features;
        }

        @Override
        public OFTableFeatures.Builder setFeatures(Set<OFTableFeatureFlag> features) {
            this.features = features;
            this.featuresSet = true;
            return this;
        }

        @Override
        public Set<OFTableConfig> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFTableFeatures.Builder setCapabilities(Set<OFTableConfig> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeatures build() {
            List<OFTableFeatureProp> properties;
            Set<OFTableConfig> capabilities;
            U64 metadataWrite;
            U64 metadataMatch;
            String name;
            Set<OFTableFeatureFlag> features;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            if (!this.commandSet) {
                throw new IllegalStateException("Property command doesn't have default value -- must be set");
            }
            if (this.command == null) {
                throw new NullPointerException("Property command must not be null");
            }
            Set<OFTableFeatureFlag> set = features = this.featuresSet ? this.features : DEFAULT_FEATURES;
            if (features == null) {
                throw new NullPointerException("Property features must not be null");
            }
            String string = name = this.nameSet ? this.name : OFTableFeaturesVer15.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            U64 u64 = metadataMatch = this.metadataMatchSet ? this.metadataMatch : DEFAULT_METADATA_MATCH;
            if (metadataMatch == null) {
                throw new NullPointerException("Property metadataMatch must not be null");
            }
            U64 u642 = metadataWrite = this.metadataWriteSet ? this.metadataWrite : DEFAULT_METADATA_WRITE;
            if (metadataWrite == null) {
                throw new NullPointerException("Property metadataWrite must not be null");
            }
            Set<OFTableConfig> set2 = capabilities = this.capabilitiesSet ? this.capabilities : DEFAULT_CAPABILITIES;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            long maxEntries = this.maxEntriesSet ? this.maxEntries : 0L;
            List<OFTableFeatureProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFTableFeaturesVer15(tableId, this.command, features, name, metadataMatch, metadataWrite, capabilities, maxEntries, properties);
        }
    }

    static class BuilderWithParent
    implements OFTableFeatures.Builder {
        final OFTableFeaturesVer15 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean commandSet;
        private OFTableFeaturesCommand command;
        private boolean featuresSet;
        private Set<OFTableFeatureFlag> features;
        private boolean nameSet;
        private String name;
        private boolean metadataMatchSet;
        private U64 metadataMatch;
        private boolean metadataWriteSet;
        private U64 metadataWrite;
        private boolean capabilitiesSet;
        private Set<OFTableConfig> capabilities;
        private boolean maxEntriesSet;
        private long maxEntries;
        private boolean propertiesSet;
        private List<OFTableFeatureProp> properties;

        BuilderWithParent(OFTableFeaturesVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableFeatures.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFTableFeatures.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMatch() {
            return this.metadataMatch;
        }

        @Override
        public OFTableFeatures.Builder setMetadataMatch(U64 metadataMatch) {
            this.metadataMatch = metadataMatch;
            this.metadataMatchSet = true;
            return this;
        }

        @Override
        public U64 getMetadataWrite() {
            return this.metadataWrite;
        }

        @Override
        public OFTableFeatures.Builder setMetadataWrite(U64 metadataWrite) {
            this.metadataWrite = metadataWrite;
            this.metadataWriteSet = true;
            return this;
        }

        @Override
        public long getConfig() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property config not supported in version 1.5");
        }

        @Override
        public OFTableFeatures.Builder setConfig(long config) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property config not supported in version 1.5");
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFTableFeatures.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public List<OFTableFeatureProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFTableFeatures.Builder setProperties(List<OFTableFeatureProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFTableFeaturesCommand getCommand() {
            return this.command;
        }

        @Override
        public OFTableFeatures.Builder setCommand(OFTableFeaturesCommand command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public Set<OFTableFeatureFlag> getFeatures() {
            return this.features;
        }

        @Override
        public OFTableFeatures.Builder setFeatures(Set<OFTableFeatureFlag> features) {
            this.features = features;
            this.featuresSet = true;
            return this;
        }

        @Override
        public Set<OFTableConfig> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFTableFeatures.Builder setCapabilities(Set<OFTableConfig> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeatures build() {
            List properties;
            Set capabilities;
            U64 metadataWrite;
            U64 metadataMatch;
            String name;
            Set features;
            OFTableFeaturesCommand command;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            OFTableFeaturesCommand oFTableFeaturesCommand = command = this.commandSet ? this.command : this.parentMessage.command;
            if (command == null) {
                throw new NullPointerException("Property command must not be null");
            }
            Set set = features = this.featuresSet ? this.features : this.parentMessage.features;
            if (features == null) {
                throw new NullPointerException("Property features must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            U64 u64 = metadataMatch = this.metadataMatchSet ? this.metadataMatch : this.parentMessage.metadataMatch;
            if (metadataMatch == null) {
                throw new NullPointerException("Property metadataMatch must not be null");
            }
            U64 u642 = metadataWrite = this.metadataWriteSet ? this.metadataWrite : this.parentMessage.metadataWrite;
            if (metadataWrite == null) {
                throw new NullPointerException("Property metadataWrite must not be null");
            }
            Set set2 = capabilities = this.capabilitiesSet ? this.capabilities : this.parentMessage.capabilities;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            long maxEntries = this.maxEntriesSet ? this.maxEntries : this.parentMessage.maxEntries;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFTableFeaturesVer15(tableId, command, features, name, metadataMatch, metadataWrite, capabilities, maxEntries, properties);
        }
    }
}

