/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropOxmValues;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropOxmValuesVer15
implements OFTableFeaturePropOxmValues {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropOxmValuesVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    private static final byte[] DEFAULT_OXM_VALUES = new byte[0];
    private final byte[] oxmValues;
    static final OFTableFeaturePropOxmValuesVer15 DEFAULT = new OFTableFeaturePropOxmValuesVer15(DEFAULT_OXM_VALUES);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropOxmValuesVer15Funnel FUNNEL = new OFTableFeaturePropOxmValuesVer15Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropOxmValuesVer15(byte[] oxmValues) {
        if (oxmValues == null) {
            throw new NullPointerException("OFTableFeaturePropOxmValuesVer15: property oxmValues cannot be null");
        }
        this.oxmValues = oxmValues;
    }

    @Override
    public int getType() {
        return 22;
    }

    @Override
    public byte[] getOxmValues() {
        return this.oxmValues;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFTableFeaturePropOxmValues.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropOxmValuesVer15(");
        b.append("oxmValues=").append(Arrays.toString(this.oxmValues));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropOxmValuesVer15 other = (OFTableFeaturePropOxmValuesVer15)obj;
        return Arrays.equals(this.oxmValues, other.oxmValues);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.oxmValues);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropOxmValuesVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropOxmValuesVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(22);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.oxmValues);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropOxmValuesVer15Funnel
    implements Funnel<OFTableFeaturePropOxmValuesVer15> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropOxmValuesVer15Funnel() {
        }

        public void funnel(OFTableFeaturePropOxmValuesVer15 message, PrimitiveSink sink) {
            sink.putShort((short)22);
            sink.putBytes(message.oxmValues);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropOxmValues> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropOxmValues readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 22) {
                throw new OFParseError("Wrong type: Expected=0x16(0x16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] oxmValues = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFTableFeaturePropOxmValuesVer15 tableFeaturePropOxmValuesVer15 = new OFTableFeaturePropOxmValuesVer15(oxmValues);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropOxmValuesVer15);
            }
            return tableFeaturePropOxmValuesVer15;
        }
    }

    static class Builder
    implements OFTableFeaturePropOxmValues.Builder {
        private boolean oxmValuesSet;
        private byte[] oxmValues;

        Builder() {
        }

        @Override
        public int getType() {
            return 22;
        }

        @Override
        public byte[] getOxmValues() {
            return this.oxmValues;
        }

        @Override
        public OFTableFeaturePropOxmValues.Builder setOxmValues(byte[] oxmValues) {
            this.oxmValues = oxmValues;
            this.oxmValuesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeaturePropOxmValues build() {
            byte[] oxmValues;
            byte[] byArray = oxmValues = this.oxmValuesSet ? this.oxmValues : DEFAULT_OXM_VALUES;
            if (oxmValues == null) {
                throw new NullPointerException("Property oxmValues must not be null");
            }
            return new OFTableFeaturePropOxmValuesVer15(oxmValues);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropOxmValues.Builder {
        final OFTableFeaturePropOxmValuesVer15 parentMessage;
        private boolean oxmValuesSet;
        private byte[] oxmValues;

        BuilderWithParent(OFTableFeaturePropOxmValuesVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 22;
        }

        @Override
        public byte[] getOxmValues() {
            return this.oxmValues;
        }

        @Override
        public OFTableFeaturePropOxmValues.Builder setOxmValues(byte[] oxmValues) {
            this.oxmValues = oxmValues;
            this.oxmValuesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeaturePropOxmValues build() {
            byte[] oxmValues;
            byte[] byArray = oxmValues = this.oxmValuesSet ? this.oxmValues : this.parentMessage.oxmValues;
            if (oxmValues == null) {
                throw new NullPointerException("Property oxmValues must not be null");
            }
            return new OFTableFeaturePropOxmValuesVer15(oxmValues);
        }
    }
}

