/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropInstructions;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionId;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionIdVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropInstructionsVer15
implements OFTableFeaturePropInstructions {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropInstructionsVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    private static final List<OFInstructionId> DEFAULT_INSTRUCTION_IDS = ImmutableList.of();
    private final List<OFInstructionId> instructionIds;
    static final OFTableFeaturePropInstructionsVer15 DEFAULT = new OFTableFeaturePropInstructionsVer15(DEFAULT_INSTRUCTION_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropInstructionsVer15Funnel FUNNEL = new OFTableFeaturePropInstructionsVer15Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropInstructionsVer15(List<OFInstructionId> instructionIds) {
        if (instructionIds == null) {
            throw new NullPointerException("OFTableFeaturePropInstructionsVer15: property instructionIds cannot be null");
        }
        this.instructionIds = instructionIds;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public List<OFInstructionId> getInstructionIds() {
        return this.instructionIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFTableFeaturePropInstructions.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropInstructionsVer15(");
        b.append("instructionIds=").append(this.instructionIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropInstructionsVer15 other = (OFTableFeaturePropInstructionsVer15)obj;
        return !(this.instructionIds == null ? other.instructionIds != null : !this.instructionIds.equals(other.instructionIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instructionIds == null ? 0 : this.instructionIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropInstructionsVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropInstructionsVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(0);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.instructionIds);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropInstructionsVer15Funnel
    implements Funnel<OFTableFeaturePropInstructionsVer15> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropInstructionsVer15Funnel() {
        }

        public void funnel(OFTableFeaturePropInstructionsVer15 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            FunnelUtils.putList(message.instructionIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropInstructions> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropInstructions readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFInstructionId> instructionIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionIdVer15.READER);
            OFTableFeaturePropInstructionsVer15 tableFeaturePropInstructionsVer15 = new OFTableFeaturePropInstructionsVer15(instructionIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropInstructionsVer15);
            }
            return tableFeaturePropInstructionsVer15;
        }
    }

    static class Builder
    implements OFTableFeaturePropInstructions.Builder {
        private boolean instructionIdsSet;
        private List<OFInstructionId> instructionIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public List<OFInstructionId> getInstructionIds() {
            return this.instructionIds;
        }

        @Override
        public OFTableFeaturePropInstructions.Builder setInstructionIds(List<OFInstructionId> instructionIds) {
            this.instructionIds = instructionIds;
            this.instructionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeaturePropInstructions build() {
            List<OFInstructionId> instructionIds;
            List<OFInstructionId> list = instructionIds = this.instructionIdsSet ? this.instructionIds : DEFAULT_INSTRUCTION_IDS;
            if (instructionIds == null) {
                throw new NullPointerException("Property instructionIds must not be null");
            }
            return new OFTableFeaturePropInstructionsVer15(instructionIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropInstructions.Builder {
        final OFTableFeaturePropInstructionsVer15 parentMessage;
        private boolean instructionIdsSet;
        private List<OFInstructionId> instructionIds;

        BuilderWithParent(OFTableFeaturePropInstructionsVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public List<OFInstructionId> getInstructionIds() {
            return this.instructionIds;
        }

        @Override
        public OFTableFeaturePropInstructions.Builder setInstructionIds(List<OFInstructionId> instructionIds) {
            this.instructionIds = instructionIds;
            this.instructionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeaturePropInstructions build() {
            List instructionIds;
            List list = instructionIds = this.instructionIdsSet ? this.instructionIds : this.parentMessage.instructionIds;
            if (instructionIds == null) {
                throw new NullPointerException("Property instructionIds must not be null");
            }
            return new OFTableFeaturePropInstructionsVer15(instructionIds);
        }
    }
}

