/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueDescPropBsnQueueName;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueDescPropBsnQueueNameVer15
implements OFQueueDescPropBsnQueueName {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueDescPropBsnQueueNameVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 12;
    private static final byte[] DEFAULT_NAME = new byte[0];
    private final byte[] name;
    static final OFQueueDescPropBsnQueueNameVer15 DEFAULT = new OFQueueDescPropBsnQueueNameVer15(DEFAULT_NAME);
    static final Reader READER = new Reader();
    static final OFQueueDescPropBsnQueueNameVer15Funnel FUNNEL = new OFQueueDescPropBsnQueueNameVer15Funnel();
    static final Writer WRITER = new Writer();

    OFQueueDescPropBsnQueueNameVer15(byte[] name) {
        if (name == null) {
            throw new NullPointerException("OFQueueDescPropBsnQueueNameVer15: property name cannot be null");
        }
        this.name = name;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 0L;
    }

    @Override
    public byte[] getName() {
        return this.name;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFQueueDescPropBsnQueueName.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueDescPropBsnQueueNameVer15(");
        b.append("name=").append(Arrays.toString(this.name));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueDescPropBsnQueueNameVer15 other = (OFQueueDescPropBsnQueueNameVer15)obj;
        return Arrays.equals(this.name, other.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.name);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueDescPropBsnQueueNameVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFQueueDescPropBsnQueueNameVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(6035143);
            bb.writeInt(0);
            bb.writeBytes(message.name);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFQueueDescPropBsnQueueNameVer15Funnel
    implements Funnel<OFQueueDescPropBsnQueueNameVer15> {
        private static final long serialVersionUID = 1L;

        OFQueueDescPropBsnQueueNameVer15Funnel() {
        }

        public void funnel(OFQueueDescPropBsnQueueNameVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(6035143);
            sink.putInt(0);
            sink.putBytes(message.name);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueDescPropBsnQueueName> {
        Reader() {
        }

        @Override
        public OFQueueDescPropBsnQueueName readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 0) {
                throw new OFParseError("Wrong expType: Expected=0x0L(0x0L), got=" + expType);
            }
            byte[] name = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFQueueDescPropBsnQueueNameVer15 queueDescPropBsnQueueNameVer15 = new OFQueueDescPropBsnQueueNameVer15(name);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueDescPropBsnQueueNameVer15);
            }
            return queueDescPropBsnQueueNameVer15;
        }
    }

    static class Builder
    implements OFQueueDescPropBsnQueueName.Builder {
        private boolean nameSet;
        private byte[] name;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 0L;
        }

        @Override
        public OFQueueDescPropBsnQueueName.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getName() {
            return this.name;
        }

        @Override
        public OFQueueDescPropBsnQueueName.Builder setName(byte[] name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFQueueDescPropBsnQueueName build() {
            byte[] name;
            byte[] byArray = name = this.nameSet ? this.name : DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            return new OFQueueDescPropBsnQueueNameVer15(name);
        }
    }

    static class BuilderWithParent
    implements OFQueueDescPropBsnQueueName.Builder {
        final OFQueueDescPropBsnQueueNameVer15 parentMessage;
        private boolean nameSet;
        private byte[] name;

        BuilderWithParent(OFQueueDescPropBsnQueueNameVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 0L;
        }

        @Override
        public OFQueueDescPropBsnQueueName.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getName() {
            return this.name;
        }

        @Override
        public OFQueueDescPropBsnQueueName.Builder setName(byte[] name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFQueueDescPropBsnQueueName build() {
            byte[] name;
            byte[] byArray = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            return new OFQueueDescPropBsnQueueNameVer15(name);
        }
    }
}

