/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFecConfigState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnForwardErrorCorrection;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnFecConfigStateSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnForwardErrorCorrectionVer15
implements OFPortDescPropBsnForwardErrorCorrection {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnForwardErrorCorrectionVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 20;
    private static final long DEFAULT_ENABLED = 0L;
    private final OFBsnFecConfigState configured;
    private final long enabled;
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnForwardErrorCorrectionVer15Funnel FUNNEL = new OFPortDescPropBsnForwardErrorCorrectionVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnForwardErrorCorrectionVer15(OFBsnFecConfigState configured, long enabled) {
        if (configured == null) {
            throw new NullPointerException("OFPortDescPropBsnForwardErrorCorrectionVer15: property configured cannot be null");
        }
        this.configured = configured;
        this.enabled = enabled;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 2L;
    }

    @Override
    public OFBsnFecConfigState getConfigured() {
        return this.configured;
    }

    @Override
    public long getEnabled() {
        return this.enabled;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortDescPropBsnForwardErrorCorrection.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnForwardErrorCorrectionVer15(");
        b.append("configured=").append((Object)this.configured);
        b.append(", ");
        b.append("enabled=").append(this.enabled);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnForwardErrorCorrectionVer15 other = (OFPortDescPropBsnForwardErrorCorrectionVer15)obj;
        if (this.configured == null ? other.configured != null : !this.configured.equals((Object)other.configured)) {
            return false;
        }
        return this.enabled == other.enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configured == null ? 0 : this.configured.hashCode());
        result = 31 * (int)(this.enabled ^ this.enabled >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnForwardErrorCorrectionVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnForwardErrorCorrectionVer15 message) {
            bb.writeShort(-1);
            bb.writeShort(20);
            bb.writeInt(6035143);
            bb.writeInt(2);
            OFBsnFecConfigStateSerializerVer15.writeTo(bb, message.configured);
            bb.writeInt(U32.t(message.enabled));
        }
    }

    static class OFPortDescPropBsnForwardErrorCorrectionVer15Funnel
    implements Funnel<OFPortDescPropBsnForwardErrorCorrectionVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnForwardErrorCorrectionVer15Funnel() {
        }

        public void funnel(OFPortDescPropBsnForwardErrorCorrectionVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)20);
            sink.putInt(6035143);
            sink.putInt(2);
            OFBsnFecConfigStateSerializerVer15.putTo(message.configured, sink);
            sink.putLong(message.enabled);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnForwardErrorCorrection> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 2) {
                throw new OFParseError("Wrong expType: Expected=0x2L(0x2L), got=" + expType);
            }
            OFBsnFecConfigState configured = OFBsnFecConfigStateSerializerVer15.readFrom(bb);
            long enabled = U32.f(bb.readInt());
            OFPortDescPropBsnForwardErrorCorrectionVer15 portDescPropBsnForwardErrorCorrectionVer15 = new OFPortDescPropBsnForwardErrorCorrectionVer15(configured, enabled);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnForwardErrorCorrectionVer15);
            }
            return portDescPropBsnForwardErrorCorrectionVer15;
        }
    }

    static class Builder
    implements OFPortDescPropBsnForwardErrorCorrection.Builder {
        private boolean configuredSet;
        private OFBsnFecConfigState configured;
        private boolean enabledSet;
        private long enabled;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 2L;
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public OFBsnFecConfigState getConfigured() {
            return this.configured;
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection.Builder setConfigured(OFBsnFecConfigState configured) {
            this.configured = configured;
            this.configuredSet = true;
            return this;
        }

        @Override
        public long getEnabled() {
            return this.enabled;
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection.Builder setEnabled(long enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection build() {
            if (!this.configuredSet) {
                throw new IllegalStateException("Property configured doesn't have default value -- must be set");
            }
            if (this.configured == null) {
                throw new NullPointerException("Property configured must not be null");
            }
            long enabled = this.enabledSet ? this.enabled : 0L;
            return new OFPortDescPropBsnForwardErrorCorrectionVer15(this.configured, enabled);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnForwardErrorCorrection.Builder {
        final OFPortDescPropBsnForwardErrorCorrectionVer15 parentMessage;
        private boolean configuredSet;
        private OFBsnFecConfigState configured;
        private boolean enabledSet;
        private long enabled;

        BuilderWithParent(OFPortDescPropBsnForwardErrorCorrectionVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 2L;
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public OFBsnFecConfigState getConfigured() {
            return this.configured;
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection.Builder setConfigured(OFBsnFecConfigState configured) {
            this.configured = configured;
            this.configuredSet = true;
            return this;
        }

        @Override
        public long getEnabled() {
            return this.enabled;
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection.Builder setEnabled(long enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnForwardErrorCorrection build() {
            OFBsnFecConfigState configured;
            OFBsnFecConfigState oFBsnFecConfigState = configured = this.configuredSet ? this.configured : this.parentMessage.configured;
            if (configured == null) {
                throw new NullPointerException("Property configured must not be null");
            }
            long enabled = this.enabledSet ? this.enabled : this.parentMessage.enabled;
            return new OFPortDescPropBsnForwardErrorCorrectionVer15(configured, enabled);
        }
    }
}

