/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPacketQueue;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.queueprop.OFQueueProp;
import org.projectfloodlight.openflow.protocol.ver15.OFQueuePropVer15;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPacketQueueVer15
implements OFPacketQueue {
    private static final Logger logger = LoggerFactory.getLogger(OFPacketQueueVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private static final OFPort DEFAULT_PORT = OFPort.ANY;
    private static final List<OFQueueProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long queueId;
    private final OFPort port;
    private final List<OFQueueProp> properties;
    static final OFPacketQueueVer15 DEFAULT = new OFPacketQueueVer15(0L, DEFAULT_PORT, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFPacketQueueVer15Funnel FUNNEL = new OFPacketQueueVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPacketQueueVer15(long queueId, OFPort port, List<OFQueueProp> properties) {
        if (port == null) {
            throw new NullPointerException("OFPacketQueueVer15: property port cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFPacketQueueVer15: property properties cannot be null");
        }
        this.queueId = queueId;
        this.port = port;
        this.properties = properties;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public OFPort getPort() {
        return this.port;
    }

    @Override
    public List<OFQueueProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPacketQueue.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPacketQueueVer15(");
        b.append("queueId=").append(this.queueId);
        b.append(", ");
        b.append("port=").append(this.port);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketQueueVer15 other = (OFPacketQueueVer15)obj;
        if (this.queueId != other.queueId) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPacketQueueVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPacketQueueVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeInt(U32.t(message.queueId));
            message.port.write4Bytes(bb);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(6);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPacketQueueVer15Funnel
    implements Funnel<OFPacketQueueVer15> {
        private static final long serialVersionUID = 1L;

        OFPacketQueueVer15Funnel() {
        }

        public void funnel(OFPacketQueueVer15 message, PrimitiveSink sink) {
            sink.putLong(message.queueId);
            message.port.putTo(sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPacketQueue> {
        Reader() {
        }

        @Override
        public OFPacketQueue readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            long queueId = U32.f(bb.readInt());
            OFPort port = OFPort.read4Bytes(bb);
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(6);
            List<OFQueueProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFQueuePropVer15.READER);
            OFPacketQueueVer15 packetQueueVer15 = new OFPacketQueueVer15(queueId, port, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)packetQueueVer15);
            }
            return packetQueueVer15;
        }
    }

    static class Builder
    implements OFPacketQueue.Builder {
        private boolean queueIdSet;
        private long queueId;
        private boolean portSet;
        private OFPort port;
        private boolean propertiesSet;
        private List<OFQueueProp> properties;

        Builder() {
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFPacketQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFPacketQueue.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public List<OFQueueProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPacketQueue.Builder setProperties(List<OFQueueProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPacketQueue build() {
            List<OFQueueProp> properties;
            OFPort port;
            long queueId = this.queueIdSet ? this.queueId : 0L;
            OFPort oFPort = port = this.portSet ? this.port : DEFAULT_PORT;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            List<OFQueueProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPacketQueueVer15(queueId, port, properties);
        }
    }

    static class BuilderWithParent
    implements OFPacketQueue.Builder {
        final OFPacketQueueVer15 parentMessage;
        private boolean queueIdSet;
        private long queueId;
        private boolean portSet;
        private OFPort port;
        private boolean propertiesSet;
        private List<OFQueueProp> properties;

        BuilderWithParent(OFPacketQueueVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFPacketQueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFPacketQueue.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public List<OFQueueProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPacketQueue.Builder setProperties(List<OFQueueProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPacketQueue build() {
            List properties;
            OFPort port;
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            OFPort oFPort = port = this.portSet ? this.port : this.parentMessage.port;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPacketQueueVer15(queueId, port, properties);
        }
    }
}

