/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.oxs.OFOxsByteCount;
import org.projectfloodlight.openflow.protocol.stat.StatField;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxsByteCountVer15
implements OFOxsByteCount {
    private static final Logger logger = LoggerFactory.getLogger(OFOxsByteCountVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFOxsByteCountVer15 DEFAULT = new OFOxsByteCountVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxsByteCountVer15Funnel FUNNEL = new OFOxsByteCountVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxsByteCountVer15(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFOxsByteCountVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 0x80020808L;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public StatField<U64> getStatField() {
        return StatField.BYTE_COUNT;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxs<U64> getCanonical() {
        return this;
    }

    @Override
    public U64 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxsByteCount.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxsByteCountVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxsByteCountVer15 other = (OFOxsByteCountVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxsByteCountVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxsByteCountVer15 message) {
            bb.writeInt(-2147350520);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFOxsByteCountVer15Funnel
    implements Funnel<OFOxsByteCountVer15> {
        private static final long serialVersionUID = 1L;

        OFOxsByteCountVer15Funnel() {
        }

        public void funnel(OFOxsByteCountVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147350520);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxsByteCount> {
        Reader() {
        }

        @Override
        public OFOxsByteCount readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147350520) {
                throw new OFParseError("Wrong typeLen: Expected=0x80020808L(0x80020808L), got=" + typeLen);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFOxsByteCountVer15 oxsByteCountVer15 = new OFOxsByteCountVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxsByteCountVer15);
            }
            return oxsByteCountVer15;
        }
    }

    static class Builder
    implements OFOxsByteCount.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 0x80020808L;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFOxsByteCount.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public StatField<U64> getStatField() {
            return StatField.BYTE_COUNT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxs<U64> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public U64 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxsByteCount build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxsByteCountVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxsByteCount.Builder {
        final OFOxsByteCountVer15 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFOxsByteCountVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 0x80020808L;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFOxsByteCount.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public StatField<U64> getStatField() {
            return StatField.BYTE_COUNT;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxs<U64> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public U64 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxsByteCount build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxsByteCountVer15(value);
        }
    }
}

