/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmPacketType;
import org.projectfloodlight.openflow.types.PacketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmPacketTypeVer15
implements OFOxmPacketType {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmPacketTypeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private final PacketType value;
    static final Reader READER = new Reader();
    static final OFOxmPacketTypeVer15Funnel FUNNEL = new OFOxmPacketTypeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmPacketTypeVer15(PacketType value) {
        if (value == null) {
            throw new NullPointerException("OFOxmPacketTypeVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147506180L;
    }

    @Override
    public PacketType getValue() {
        return this.value;
    }

    @Override
    public MatchField<PacketType> getMatchField() {
        return MatchField.PACKET_TYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<PacketType> getCanonical() {
        return this;
    }

    @Override
    public PacketType getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmPacketType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmPacketTypeVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmPacketTypeVer15 other = (OFOxmPacketTypeVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmPacketTypeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmPacketTypeVer15 message) {
            bb.writeInt(-2147461116);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmPacketTypeVer15Funnel
    implements Funnel<OFOxmPacketTypeVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmPacketTypeVer15Funnel() {
        }

        public void funnel(OFOxmPacketTypeVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147461116);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmPacketType> {
        Reader() {
        }

        @Override
        public OFOxmPacketType readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147461116) {
                throw new OFParseError("Wrong typeLen: Expected=0x80005804L(0x80005804L), got=" + typeLen);
            }
            PacketType value = PacketType.read4Bytes(bb);
            OFOxmPacketTypeVer15 oxmPacketTypeVer15 = new OFOxmPacketTypeVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmPacketTypeVer15);
            }
            return oxmPacketTypeVer15;
        }
    }

    static class Builder
    implements OFOxmPacketType.Builder {
        private boolean valueSet;
        private PacketType value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147506180L;
        }

        @Override
        public PacketType getValue() {
            return this.value;
        }

        @Override
        public OFOxmPacketType.Builder setValue(PacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<PacketType> getMatchField() {
            return MatchField.PACKET_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<PacketType> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public PacketType getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmPacketType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmPacketTypeVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFOxmPacketType.Builder {
        final OFOxmPacketTypeVer15 parentMessage;
        private boolean valueSet;
        private PacketType value;

        BuilderWithParent(OFOxmPacketTypeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147506180L;
        }

        @Override
        public PacketType getValue() {
            return this.value;
        }

        @Override
        public OFOxmPacketType.Builder setValue(PacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<PacketType> getMatchField() {
            return MatchField.PACKET_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<PacketType> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public PacketType getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmPacketType build() {
            PacketType value;
            PacketType packetType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmPacketTypeVer15(value);
        }
    }
}

