/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingTpSrc;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingTpSrcVer15
implements OFOxmConnTrackingTpSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingTpSrcVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private final TransportPort value;
    static final OFOxmConnTrackingTpSrcVer15 DEFAULT = new OFOxmConnTrackingTpSrcVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingTpSrcVer15Funnel FUNNEL = new OFOxmConnTrackingTpSrcVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingTpSrcVer15(TransportPort value) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingTpSrcVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 129026L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.CONN_TRACKING_TP_SRC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        return this;
    }

    @Override
    public TransportPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmConnTrackingTpSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingTpSrcVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingTpSrcVer15 other = (OFOxmConnTrackingTpSrcVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingTpSrcVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingTpSrcVer15 message) {
            bb.writeInt(129026);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmConnTrackingTpSrcVer15Funnel
    implements Funnel<OFOxmConnTrackingTpSrcVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingTpSrcVer15Funnel() {
        }

        public void funnel(OFOxmConnTrackingTpSrcVer15 message, PrimitiveSink sink) {
            sink.putInt(129026);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingTpSrc> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingTpSrc readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 129026) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f802L(0x1f802L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            OFOxmConnTrackingTpSrcVer15 oxmConnTrackingTpSrcVer15 = new OFOxmConnTrackingTpSrcVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingTpSrcVer15);
            }
            return oxmConnTrackingTpSrcVer15;
        }
    }

    static class Builder
    implements OFOxmConnTrackingTpSrc.Builder {
        private boolean valueSet;
        private TransportPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 129026L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingTpSrc.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.CONN_TRACKING_TP_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmConnTrackingTpSrc build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingTpSrcVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingTpSrc.Builder {
        final OFOxmConnTrackingTpSrcVer15 parentMessage;
        private boolean valueSet;
        private TransportPort value;

        BuilderWithParent(OFOxmConnTrackingTpSrcVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 129026L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingTpSrc.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.CONN_TRACKING_TP_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmConnTrackingTpSrc build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingTpSrcVer15(value);
        }
    }
}

