/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupBucketPropWeight;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupBucketPropWeightVer15
implements OFGroupBucketPropWeight {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupBucketPropWeightVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final int DEFAULT_WEIGHT = 0;
    private final int weight;
    static final OFGroupBucketPropWeightVer15 DEFAULT = new OFGroupBucketPropWeightVer15(0);
    static final Reader READER = new Reader();
    static final OFGroupBucketPropWeightVer15Funnel FUNNEL = new OFGroupBucketPropWeightVer15Funnel();
    static final Writer WRITER = new Writer();

    OFGroupBucketPropWeightVer15(int weight) {
        this.weight = weight;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFGroupBucketPropWeight.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupBucketPropWeightVer15(");
        b.append("weight=").append(this.weight);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupBucketPropWeightVer15 other = (OFGroupBucketPropWeightVer15)obj;
        return this.weight == other.weight;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.weight;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupBucketPropWeightVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupBucketPropWeightVer15 message) {
            bb.writeShort(0);
            bb.writeShort(8);
            bb.writeShort((int)U16.t(message.weight));
            bb.writeZero(2);
        }
    }

    static class OFGroupBucketPropWeightVer15Funnel
    implements Funnel<OFGroupBucketPropWeightVer15> {
        private static final long serialVersionUID = 1L;

        OFGroupBucketPropWeightVer15Funnel() {
        }

        public void funnel(OFGroupBucketPropWeightVer15 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)8);
            sink.putInt(message.weight);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupBucketPropWeight> {
        Reader() {
        }

        @Override
        public OFGroupBucketPropWeight readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int weight = U16.f(bb.readShort());
            bb.skipBytes(2);
            OFGroupBucketPropWeightVer15 groupBucketPropWeightVer15 = new OFGroupBucketPropWeightVer15(weight);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupBucketPropWeightVer15);
            }
            return groupBucketPropWeightVer15;
        }
    }

    static class Builder
    implements OFGroupBucketPropWeight.Builder {
        private boolean weightSet;
        private int weight;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public OFGroupBucketPropWeight.Builder setWeight(int weight) {
            this.weight = weight;
            this.weightSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFGroupBucketPropWeight build() {
            int weight = this.weightSet ? this.weight : 0;
            return new OFGroupBucketPropWeightVer15(weight);
        }
    }

    static class BuilderWithParent
    implements OFGroupBucketPropWeight.Builder {
        final OFGroupBucketPropWeightVer15 parentMessage;
        private boolean weightSet;
        private int weight;

        BuilderWithParent(OFGroupBucketPropWeightVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public OFGroupBucketPropWeight.Builder setWeight(int weight) {
            this.weight = weight;
            this.weightSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFGroupBucketPropWeight build() {
            int weight = this.weightSet ? this.weight : this.parentMessage.weight;
            return new OFGroupBucketPropWeightVer15(weight);
        }
    }
}

