/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowMonitorCommand;
import org.projectfloodlight.openflow.protocol.OFFlowMonitorEntry;
import org.projectfloodlight.openflow.protocol.OFFlowMonitorFlags;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver15.ChannelUtilsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowMonitorCommandSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowMonitorFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowMonitorEntryVer15
implements OFFlowMonitorEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowMonitorEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    private static final long DEFAULT_MONITOR_ID = 0L;
    private static final long DEFAULT_OUT_PORT = 0L;
    private static final long DEFAULT_OUT_GROUP = 0L;
    private static final Set<OFFlowMonitorFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final Match DEFAULT_MATCH = OFFactoryVer15.MATCH_WILDCARD_ALL;
    private final long monitorId;
    private final long outPort;
    private final long outGroup;
    private final Set<OFFlowMonitorFlags> flags;
    private final TableId tableId;
    private final OFFlowMonitorCommand command;
    private final Match match;
    static final Reader READER = new Reader();
    static final OFFlowMonitorEntryVer15Funnel FUNNEL = new OFFlowMonitorEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFFlowMonitorEntryVer15(long monitorId, long outPort, long outGroup, Set<OFFlowMonitorFlags> flags, TableId tableId, OFFlowMonitorCommand command, Match match) {
        if (flags == null) {
            throw new NullPointerException("OFFlowMonitorEntryVer15: property flags cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFFlowMonitorEntryVer15: property tableId cannot be null");
        }
        if (command == null) {
            throw new NullPointerException("OFFlowMonitorEntryVer15: property command cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFFlowMonitorEntryVer15: property match cannot be null");
        }
        this.monitorId = monitorId;
        this.outPort = outPort;
        this.outGroup = outGroup;
        this.flags = flags;
        this.tableId = tableId;
        this.command = command;
        this.match = match;
    }

    @Override
    public long getMonitorId() {
        return this.monitorId;
    }

    @Override
    public long getOutPort() {
        return this.outPort;
    }

    @Override
    public long getOutGroup() {
        return this.outGroup;
    }

    @Override
    public Set<OFFlowMonitorFlags> getFlags() {
        return this.flags;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public OFFlowMonitorCommand getCommand() {
        return this.command;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFFlowMonitorEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowMonitorEntryVer15(");
        b.append("monitorId=").append(this.monitorId);
        b.append(", ");
        b.append("outPort=").append(this.outPort);
        b.append(", ");
        b.append("outGroup=").append(this.outGroup);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("command=").append((Object)this.command);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowMonitorEntryVer15 other = (OFFlowMonitorEntryVer15)obj;
        if (this.monitorId != other.monitorId) {
            return false;
        }
        if (this.outPort != other.outPort) {
            return false;
        }
        if (this.outGroup != other.outGroup) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.command == null ? other.command != null : !this.command.equals((Object)other.command)) {
            return false;
        }
        return !(this.match == null ? other.match != null : !this.match.equals(other.match));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.monitorId ^ this.monitorId >>> 32);
        result = 31 * (int)(this.outPort ^ this.outPort >>> 32);
        result = 31 * (int)(this.outGroup ^ this.outGroup >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowMonitorEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFlowMonitorEntryVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeInt(U32.t(message.monitorId));
            bb.writeInt(U32.t(message.outPort));
            bb.writeInt(U32.t(message.outGroup));
            OFFlowMonitorFlagsSerializerVer15.writeTo(bb, message.flags);
            message.tableId.writeByte(bb);
            OFFlowMonitorCommandSerializerVer15.writeTo(bb, message.command);
            message.match.writeTo(bb);
        }
    }

    static class OFFlowMonitorEntryVer15Funnel
    implements Funnel<OFFlowMonitorEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFFlowMonitorEntryVer15Funnel() {
        }

        public void funnel(OFFlowMonitorEntryVer15 message, PrimitiveSink sink) {
            sink.putLong(message.monitorId);
            sink.putLong(message.outPort);
            sink.putLong(message.outGroup);
            OFFlowMonitorFlagsSerializerVer15.putTo(message.flags, sink);
            message.tableId.putTo(sink);
            OFFlowMonitorCommandSerializerVer15.putTo(message.command, sink);
            message.match.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowMonitorEntry> {
        Reader() {
        }

        @Override
        public OFFlowMonitorEntry readFrom(ByteBuf bb) throws OFParseError {
            long monitorId = U32.f(bb.readInt());
            long outPort = U32.f(bb.readInt());
            long outGroup = U32.f(bb.readInt());
            Set<OFFlowMonitorFlags> flags = OFFlowMonitorFlagsSerializerVer15.readFrom(bb);
            TableId tableId = TableId.readByte(bb);
            OFFlowMonitorCommand command = OFFlowMonitorCommandSerializerVer15.readFrom(bb);
            Match match = ChannelUtilsVer15.readOFMatch(bb);
            OFFlowMonitorEntryVer15 flowMonitorEntryVer15 = new OFFlowMonitorEntryVer15(monitorId, outPort, outGroup, flags, tableId, command, match);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowMonitorEntryVer15);
            }
            return flowMonitorEntryVer15;
        }
    }

    static class Builder
    implements OFFlowMonitorEntry.Builder {
        private boolean monitorIdSet;
        private long monitorId;
        private boolean outPortSet;
        private long outPort;
        private boolean outGroupSet;
        private long outGroup;
        private boolean flagsSet;
        private Set<OFFlowMonitorFlags> flags;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean commandSet;
        private OFFlowMonitorCommand command;
        private boolean matchSet;
        private Match match;

        Builder() {
        }

        @Override
        public long getMonitorId() {
            return this.monitorId;
        }

        @Override
        public OFFlowMonitorEntry.Builder setMonitorId(long monitorId) {
            this.monitorId = monitorId;
            this.monitorIdSet = true;
            return this;
        }

        @Override
        public long getOutPort() {
            return this.outPort;
        }

        @Override
        public OFFlowMonitorEntry.Builder setOutPort(long outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public long getOutGroup() {
            return this.outGroup;
        }

        @Override
        public OFFlowMonitorEntry.Builder setOutGroup(long outGroup) {
            this.outGroup = outGroup;
            this.outGroupSet = true;
            return this;
        }

        @Override
        public Set<OFFlowMonitorFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowMonitorEntry.Builder setFlags(Set<OFFlowMonitorFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowMonitorEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFFlowMonitorCommand getCommand() {
            return this.command;
        }

        @Override
        public OFFlowMonitorEntry.Builder setCommand(OFFlowMonitorCommand command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowMonitorEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFFlowMonitorEntry build() {
            Match match;
            TableId tableId;
            Set<OFFlowMonitorFlags> flags;
            long monitorId = this.monitorIdSet ? this.monitorId : 0L;
            long outPort = this.outPortSet ? this.outPort : 0L;
            long outGroup = this.outGroupSet ? this.outGroup : 0L;
            Set<OFFlowMonitorFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            if (!this.commandSet) {
                throw new IllegalStateException("Property command doesn't have default value -- must be set");
            }
            if (this.command == null) {
                throw new NullPointerException("Property command must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            return new OFFlowMonitorEntryVer15(monitorId, outPort, outGroup, flags, tableId, this.command, match);
        }
    }

    static class BuilderWithParent
    implements OFFlowMonitorEntry.Builder {
        final OFFlowMonitorEntryVer15 parentMessage;
        private boolean monitorIdSet;
        private long monitorId;
        private boolean outPortSet;
        private long outPort;
        private boolean outGroupSet;
        private long outGroup;
        private boolean flagsSet;
        private Set<OFFlowMonitorFlags> flags;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean commandSet;
        private OFFlowMonitorCommand command;
        private boolean matchSet;
        private Match match;

        BuilderWithParent(OFFlowMonitorEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getMonitorId() {
            return this.monitorId;
        }

        @Override
        public OFFlowMonitorEntry.Builder setMonitorId(long monitorId) {
            this.monitorId = monitorId;
            this.monitorIdSet = true;
            return this;
        }

        @Override
        public long getOutPort() {
            return this.outPort;
        }

        @Override
        public OFFlowMonitorEntry.Builder setOutPort(long outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public long getOutGroup() {
            return this.outGroup;
        }

        @Override
        public OFFlowMonitorEntry.Builder setOutGroup(long outGroup) {
            this.outGroup = outGroup;
            this.outGroupSet = true;
            return this;
        }

        @Override
        public Set<OFFlowMonitorFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFFlowMonitorEntry.Builder setFlags(Set<OFFlowMonitorFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowMonitorEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFFlowMonitorCommand getCommand() {
            return this.command;
        }

        @Override
        public OFFlowMonitorEntry.Builder setCommand(OFFlowMonitorCommand command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowMonitorEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFFlowMonitorEntry build() {
            Match match;
            OFFlowMonitorCommand command;
            TableId tableId;
            Set flags;
            long monitorId = this.monitorIdSet ? this.monitorId : this.parentMessage.monitorId;
            long outPort = this.outPortSet ? this.outPort : this.parentMessage.outPort;
            long outGroup = this.outGroupSet ? this.outGroup : this.parentMessage.outGroup;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            OFFlowMonitorCommand oFFlowMonitorCommand = command = this.commandSet ? this.command : this.parentMessage.command;
            if (command == null) {
                throw new NullPointerException("Property command must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            return new OFFlowMonitorEntryVer15(monitorId, outPort, outGroup, flags, tableId, command, match);
        }
    }
}

