/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFGroupBucket;
import org.projectfloodlight.openflow.protocol.OFGroupBucketProp;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.ver15.OFActionVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupBucketPropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupBucketSerializerVer15;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBucketVer15
implements OFBucket {
    private static final Logger logger = LoggerFactory.getLogger(OFBucketVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    private static final List<OFAction> DEFAULT_ACTIONS = ImmutableList.of();
    private static final List<OFGroupBucketProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final OFGroupBucket bucketId;
    private final List<OFAction> actions;
    private final List<OFGroupBucketProp> properties;
    static final Reader READER = new Reader();
    static final OFBucketVer15Funnel FUNNEL = new OFBucketVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBucketVer15(OFGroupBucket bucketId, List<OFAction> actions, List<OFGroupBucketProp> properties) {
        if (bucketId == null) {
            throw new NullPointerException("OFBucketVer15: property bucketId cannot be null");
        }
        if (actions == null) {
            throw new NullPointerException("OFBucketVer15: property actions cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFBucketVer15: property properties cannot be null");
        }
        this.bucketId = bucketId;
        this.actions = actions;
        this.properties = properties;
    }

    @Override
    public int getWeight() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property weight not supported in version 1.5");
    }

    @Override
    public OFPort getWatchPort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property watchPort not supported in version 1.5");
    }

    @Override
    public OFGroup getWatchGroup() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property watchGroup not supported in version 1.5");
    }

    @Override
    public List<OFAction> getActions() {
        return this.actions;
    }

    @Override
    public OFGroupBucket getBucketId() {
        return this.bucketId;
    }

    @Override
    public List<OFGroupBucketProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBucket.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBucketVer15(");
        b.append("bucketId=").append((Object)this.bucketId);
        b.append(", ");
        b.append("actions=").append(this.actions);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBucketVer15 other = (OFBucketVer15)obj;
        if (this.bucketId == null ? other.bucketId != null : !this.bucketId.equals((Object)other.bucketId)) {
            return false;
        }
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bucketId == null ? 0 : this.bucketId.hashCode());
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBucketVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBucketVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            int actionArrayLenIndex = bb.writerIndex();
            bb.writeShort(0);
            OFGroupBucketSerializerVer15.writeTo(bb, message.bucketId);
            int actionsStartIndex = bb.writerIndex();
            ChannelUtils.writeList(bb, message.actions);
            int actionsLength = bb.writerIndex() - actionsStartIndex;
            bb.setShort(actionArrayLenIndex, actionsLength);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBucketVer15Funnel
    implements Funnel<OFBucketVer15> {
        private static final long serialVersionUID = 1L;

        OFBucketVer15Funnel() {
        }

        public void funnel(OFBucketVer15 message, PrimitiveSink sink) {
            OFGroupBucketSerializerVer15.putTo(message.bucketId, sink);
            FunnelUtils.putList(message.actions, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBucket> {
        Reader() {
        }

        @Override
        public OFBucket readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int actionArrayLen = U16.f(bb.readShort());
            OFGroupBucket bucketId = OFGroupBucketSerializerVer15.readFrom(bb);
            List<OFAction> actions = ChannelUtils.readList(bb, actionArrayLen, OFActionVer15.READER);
            List<OFGroupBucketProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFGroupBucketPropVer15.READER);
            OFBucketVer15 bucketVer15 = new OFBucketVer15(bucketId, actions, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bucketVer15);
            }
            return bucketVer15;
        }
    }

    static class Builder
    implements OFBucket.Builder {
        private boolean bucketIdSet;
        private OFGroupBucket bucketId;
        private boolean actionsSet;
        private List<OFAction> actions;
        private boolean propertiesSet;
        private List<OFGroupBucketProp> properties;

        Builder() {
        }

        @Override
        public int getWeight() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property weight not supported in version 1.5");
        }

        @Override
        public OFBucket.Builder setWeight(int weight) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property weight not supported in version 1.5");
        }

        @Override
        public OFPort getWatchPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property watchPort not supported in version 1.5");
        }

        @Override
        public OFBucket.Builder setWatchPort(OFPort watchPort) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property watchPort not supported in version 1.5");
        }

        @Override
        public OFGroup getWatchGroup() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property watchGroup not supported in version 1.5");
        }

        @Override
        public OFBucket.Builder setWatchGroup(OFGroup watchGroup) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property watchGroup not supported in version 1.5");
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFBucket.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFGroupBucket getBucketId() {
            return this.bucketId;
        }

        @Override
        public OFBucket.Builder setBucketId(OFGroupBucket bucketId) {
            this.bucketId = bucketId;
            this.bucketIdSet = true;
            return this;
        }

        @Override
        public List<OFGroupBucketProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBucket.Builder setProperties(List<OFGroupBucketProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBucket build() {
            List<OFGroupBucketProp> properties;
            List<OFAction> actions;
            if (!this.bucketIdSet) {
                throw new IllegalStateException("Property bucketId doesn't have default value -- must be set");
            }
            if (this.bucketId == null) {
                throw new NullPointerException("Property bucketId must not be null");
            }
            List<OFAction> list = actions = this.actionsSet ? this.actions : DEFAULT_ACTIONS;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            List<OFGroupBucketProp> list2 = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBucketVer15(this.bucketId, actions, properties);
        }
    }

    static class BuilderWithParent
    implements OFBucket.Builder {
        final OFBucketVer15 parentMessage;
        private boolean bucketIdSet;
        private OFGroupBucket bucketId;
        private boolean actionsSet;
        private List<OFAction> actions;
        private boolean propertiesSet;
        private List<OFGroupBucketProp> properties;

        BuilderWithParent(OFBucketVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getWeight() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property weight not supported in version 1.5");
        }

        @Override
        public OFBucket.Builder setWeight(int weight) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property weight not supported in version 1.5");
        }

        @Override
        public OFPort getWatchPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property watchPort not supported in version 1.5");
        }

        @Override
        public OFBucket.Builder setWatchPort(OFPort watchPort) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property watchPort not supported in version 1.5");
        }

        @Override
        public OFGroup getWatchGroup() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property watchGroup not supported in version 1.5");
        }

        @Override
        public OFBucket.Builder setWatchGroup(OFGroup watchGroup) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property watchGroup not supported in version 1.5");
        }

        @Override
        public List<OFAction> getActions() {
            return this.actions;
        }

        @Override
        public OFBucket.Builder setActions(List<OFAction> actions) {
            this.actions = actions;
            this.actionsSet = true;
            return this;
        }

        @Override
        public OFGroupBucket getBucketId() {
            return this.bucketId;
        }

        @Override
        public OFBucket.Builder setBucketId(OFGroupBucket bucketId) {
            this.bucketId = bucketId;
            this.bucketIdSet = true;
            return this;
        }

        @Override
        public List<OFGroupBucketProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBucket.Builder setProperties(List<OFGroupBucketProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBucket build() {
            List properties;
            List actions;
            OFGroupBucket bucketId;
            OFGroupBucket oFGroupBucket = bucketId = this.bucketIdSet ? this.bucketId : this.parentMessage.bucketId;
            if (bucketId == null) {
                throw new NullPointerException("Property bucketId must not be null");
            }
            List list = actions = this.actionsSet ? this.actions : this.parentMessage.actions;
            if (actions == null) {
                throw new NullPointerException("Property actions must not be null");
            }
            List list2 = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBucketVer15(bucketId, actions, properties);
        }
    }
}

