/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvVni;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvVniVer15
implements OFBsnTlvVni {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvVniVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvVniVer15 DEFAULT = new OFBsnTlvVniVer15(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvVniVer15Funnel FUNNEL = new OFBsnTlvVniVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvVniVer15(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 86;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvVni.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvVniVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvVniVer15 other = (OFBsnTlvVniVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvVniVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvVniVer15 message) {
            bb.writeShort(86);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvVniVer15Funnel
    implements Funnel<OFBsnTlvVniVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvVniVer15Funnel() {
        }

        public void funnel(OFBsnTlvVniVer15 message, PrimitiveSink sink) {
            sink.putShort((short)86);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvVni> {
        Reader() {
        }

        @Override
        public OFBsnTlvVni readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 86) {
                throw new OFParseError("Wrong type: Expected=0x56(0x56), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvVniVer15 bsnTlvVniVer15 = new OFBsnTlvVniVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvVniVer15);
            }
            return bsnTlvVniVer15;
        }
    }

    static class Builder
    implements OFBsnTlvVni.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 86;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVni.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvVni build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvVniVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvVni.Builder {
        final OFBsnTlvVniVer15 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvVniVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 86;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVni.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvVni build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvVniVer15(value);
        }
    }
}

