/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvQueueWeight;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvQueueWeightVer15
implements OFBsnTlvQueueWeight {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvQueueWeightVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvQueueWeightVer15 DEFAULT = new OFBsnTlvQueueWeightVer15(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvQueueWeightVer15Funnel FUNNEL = new OFBsnTlvQueueWeightVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvQueueWeightVer15(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 21;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvQueueWeight.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvQueueWeightVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvQueueWeightVer15 other = (OFBsnTlvQueueWeightVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvQueueWeightVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvQueueWeightVer15 message) {
            bb.writeShort(21);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvQueueWeightVer15Funnel
    implements Funnel<OFBsnTlvQueueWeightVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvQueueWeightVer15Funnel() {
        }

        public void funnel(OFBsnTlvQueueWeightVer15 message, PrimitiveSink sink) {
            sink.putShort((short)21);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvQueueWeight> {
        Reader() {
        }

        @Override
        public OFBsnTlvQueueWeight readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 21) {
                throw new OFParseError("Wrong type: Expected=0x15(0x15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvQueueWeightVer15 bsnTlvQueueWeightVer15 = new OFBsnTlvQueueWeightVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvQueueWeightVer15);
            }
            return bsnTlvQueueWeightVer15;
        }
    }

    static class Builder
    implements OFBsnTlvQueueWeight.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 21;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvQueueWeight.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvQueueWeight build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvQueueWeightVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvQueueWeight.Builder {
        final OFBsnTlvQueueWeightVer15 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvQueueWeightVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 21;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvQueueWeight.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvQueueWeight build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvQueueWeightVer15(value);
        }
    }
}

