/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPortSpeedGbps;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPortSpeedGbpsVer15
implements OFBsnTlvPortSpeedGbps {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPortSpeedGbpsVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvPortSpeedGbpsVer15 DEFAULT = new OFBsnTlvPortSpeedGbpsVer15(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvPortSpeedGbpsVer15Funnel FUNNEL = new OFBsnTlvPortSpeedGbpsVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPortSpeedGbpsVer15(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 156;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvPortSpeedGbps.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPortSpeedGbpsVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPortSpeedGbpsVer15 other = (OFBsnTlvPortSpeedGbpsVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPortSpeedGbpsVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPortSpeedGbpsVer15 message) {
            bb.writeShort(156);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvPortSpeedGbpsVer15Funnel
    implements Funnel<OFBsnTlvPortSpeedGbpsVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPortSpeedGbpsVer15Funnel() {
        }

        public void funnel(OFBsnTlvPortSpeedGbpsVer15 message, PrimitiveSink sink) {
            sink.putShort((short)156);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPortSpeedGbps> {
        Reader() {
        }

        @Override
        public OFBsnTlvPortSpeedGbps readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 156) {
                throw new OFParseError("Wrong type: Expected=0x9c(0x9c), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvPortSpeedGbpsVer15 bsnTlvPortSpeedGbpsVer15 = new OFBsnTlvPortSpeedGbpsVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPortSpeedGbpsVer15);
            }
            return bsnTlvPortSpeedGbpsVer15;
        }
    }

    static class Builder
    implements OFBsnTlvPortSpeedGbps.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 156;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortSpeedGbps.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPortSpeedGbps build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvPortSpeedGbpsVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPortSpeedGbps.Builder {
        final OFBsnTlvPortSpeedGbpsVer15 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvPortSpeedGbpsVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 156;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortSpeedGbps.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPortSpeedGbps build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvPortSpeedGbpsVer15(value);
        }
    }
}

