/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPartnerPortPriority;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPartnerPortPriorityVer15
implements OFBsnTlvPartnerPortPriority {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPartnerPortPriorityVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvPartnerPortPriorityVer15 DEFAULT = new OFBsnTlvPartnerPortPriorityVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvPartnerPortPriorityVer15Funnel FUNNEL = new OFBsnTlvPartnerPortPriorityVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPartnerPortPriorityVer15(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 49;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvPartnerPortPriority.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPartnerPortPriorityVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPartnerPortPriorityVer15 other = (OFBsnTlvPartnerPortPriorityVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPartnerPortPriorityVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPartnerPortPriorityVer15 message) {
            bb.writeShort(49);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvPartnerPortPriorityVer15Funnel
    implements Funnel<OFBsnTlvPartnerPortPriorityVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPartnerPortPriorityVer15Funnel() {
        }

        public void funnel(OFBsnTlvPartnerPortPriorityVer15 message, PrimitiveSink sink) {
            sink.putShort((short)49);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPartnerPortPriority> {
        Reader() {
        }

        @Override
        public OFBsnTlvPartnerPortPriority readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 49) {
                throw new OFParseError("Wrong type: Expected=0x31(0x31), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvPartnerPortPriorityVer15 bsnTlvPartnerPortPriorityVer15 = new OFBsnTlvPartnerPortPriorityVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPartnerPortPriorityVer15);
            }
            return bsnTlvPartnerPortPriorityVer15;
        }
    }

    static class Builder
    implements OFBsnTlvPartnerPortPriority.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 49;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerPortPriority.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPartnerPortPriority build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvPartnerPortPriorityVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPartnerPortPriority.Builder {
        final OFBsnTlvPartnerPortPriorityVer15 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvPartnerPortPriorityVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 49;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerPortPriority.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPartnerPortPriority build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvPartnerPortPriorityVer15(value);
        }
    }
}

