/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnMulticastPacket;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMulticastPacket;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnMulticastPacketSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMulticastPacketVer15
implements OFBsnTlvMulticastPacket {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMulticastPacketVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnMulticastPacket value;
    static final Reader READER = new Reader();
    static final OFBsnTlvMulticastPacketVer15Funnel FUNNEL = new OFBsnTlvMulticastPacketVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMulticastPacketVer15(OFBsnMulticastPacket value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvMulticastPacketVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 170;
    }

    @Override
    public OFBsnMulticastPacket getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvMulticastPacket.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMulticastPacketVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMulticastPacketVer15 other = (OFBsnTlvMulticastPacketVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMulticastPacketVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMulticastPacketVer15 message) {
            bb.writeShort(170);
            bb.writeShort(6);
            OFBsnMulticastPacketSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvMulticastPacketVer15Funnel
    implements Funnel<OFBsnTlvMulticastPacketVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMulticastPacketVer15Funnel() {
        }

        public void funnel(OFBsnTlvMulticastPacketVer15 message, PrimitiveSink sink) {
            sink.putShort((short)170);
            sink.putShort((short)6);
            OFBsnMulticastPacketSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMulticastPacket> {
        Reader() {
        }

        @Override
        public OFBsnTlvMulticastPacket readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 170) {
                throw new OFParseError("Wrong type: Expected=0xaa(0xaa), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnMulticastPacket value = OFBsnMulticastPacketSerializerVer15.readFrom(bb);
            OFBsnTlvMulticastPacketVer15 bsnTlvMulticastPacketVer15 = new OFBsnTlvMulticastPacketVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMulticastPacketVer15);
            }
            return bsnTlvMulticastPacketVer15;
        }
    }

    static class Builder
    implements OFBsnTlvMulticastPacket.Builder {
        private boolean valueSet;
        private OFBsnMulticastPacket value;

        Builder() {
        }

        @Override
        public int getType() {
            return 170;
        }

        @Override
        public OFBsnMulticastPacket getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMulticastPacket.Builder setValue(OFBsnMulticastPacket value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvMulticastPacket build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvMulticastPacketVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMulticastPacket.Builder {
        final OFBsnTlvMulticastPacketVer15 parentMessage;
        private boolean valueSet;
        private OFBsnMulticastPacket value;

        BuilderWithParent(OFBsnTlvMulticastPacketVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 170;
        }

        @Override
        public OFBsnMulticastPacket getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMulticastPacket.Builder setValue(OFBsnMulticastPacket value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvMulticastPacket build() {
            OFBsnMulticastPacket value;
            OFBsnMulticastPacket oFBsnMulticastPacket = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvMulticastPacketVer15(value);
        }
    }
}

