/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvInternalGatewayMac;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvInternalGatewayMacVer15
implements OFBsnTlvInternalGatewayMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvInternalGatewayMacVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFBsnTlvInternalGatewayMacVer15 DEFAULT = new OFBsnTlvInternalGatewayMacVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvInternalGatewayMacVer15Funnel FUNNEL = new OFBsnTlvInternalGatewayMacVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvInternalGatewayMacVer15(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvInternalGatewayMacVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 28;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvInternalGatewayMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvInternalGatewayMacVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvInternalGatewayMacVer15 other = (OFBsnTlvInternalGatewayMacVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvInternalGatewayMacVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvInternalGatewayMacVer15 message) {
            bb.writeShort(28);
            bb.writeShort(10);
            message.value.write6Bytes(bb);
        }
    }

    static class OFBsnTlvInternalGatewayMacVer15Funnel
    implements Funnel<OFBsnTlvInternalGatewayMacVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvInternalGatewayMacVer15Funnel() {
        }

        public void funnel(OFBsnTlvInternalGatewayMacVer15 message, PrimitiveSink sink) {
            sink.putShort((short)28);
            sink.putShort((short)10);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvInternalGatewayMac> {
        Reader() {
        }

        @Override
        public OFBsnTlvInternalGatewayMac readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 28) {
                throw new OFParseError("Wrong type: Expected=0x1c(0x1c), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFBsnTlvInternalGatewayMacVer15 bsnTlvInternalGatewayMacVer15 = new OFBsnTlvInternalGatewayMacVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvInternalGatewayMacVer15);
            }
            return bsnTlvInternalGatewayMacVer15;
        }
    }

    static class Builder
    implements OFBsnTlvInternalGatewayMac.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public int getType() {
            return 28;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvInternalGatewayMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvInternalGatewayMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvInternalGatewayMacVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvInternalGatewayMac.Builder {
        final OFBsnTlvInternalGatewayMacVer15 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFBsnTlvInternalGatewayMacVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 28;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvInternalGatewayMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvInternalGatewayMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvInternalGatewayMacVer15(value);
        }
    }
}

