/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBroadcastQueryTimeout;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBroadcastQueryTimeoutVer15
implements OFBsnTlvBroadcastQueryTimeout {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBroadcastQueryTimeoutVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvBroadcastQueryTimeoutVer15 DEFAULT = new OFBsnTlvBroadcastQueryTimeoutVer15(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvBroadcastQueryTimeoutVer15Funnel FUNNEL = new OFBsnTlvBroadcastQueryTimeoutVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBroadcastQueryTimeoutVer15(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvBroadcastQueryTimeout.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBroadcastQueryTimeoutVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBroadcastQueryTimeoutVer15 other = (OFBsnTlvBroadcastQueryTimeoutVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBroadcastQueryTimeoutVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBroadcastQueryTimeoutVer15 message) {
            bb.writeShort(10);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvBroadcastQueryTimeoutVer15Funnel
    implements Funnel<OFBsnTlvBroadcastQueryTimeoutVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBroadcastQueryTimeoutVer15Funnel() {
        }

        public void funnel(OFBsnTlvBroadcastQueryTimeoutVer15 message, PrimitiveSink sink) {
            sink.putShort((short)10);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBroadcastQueryTimeout> {
        Reader() {
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 10) {
                throw new OFParseError("Wrong type: Expected=0xa(0xa), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvBroadcastQueryTimeoutVer15 bsnTlvBroadcastQueryTimeoutVer15 = new OFBsnTlvBroadcastQueryTimeoutVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBroadcastQueryTimeoutVer15);
            }
            return bsnTlvBroadcastQueryTimeoutVer15;
        }
    }

    static class Builder
    implements OFBsnTlvBroadcastQueryTimeout.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 10;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvBroadcastQueryTimeoutVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBroadcastQueryTimeout.Builder {
        final OFBsnTlvBroadcastQueryTimeoutVer15 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvBroadcastQueryTimeoutVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 10;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvBroadcastQueryTimeoutVer15(value);
        }
    }
}

