/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U128;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableStatsEntryVer15
implements OFBsnGentableStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 24;
    private static final long DEFAULT_ENTRY_COUNT = 0L;
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private final GenTableId tableId;
    private final long entryCount;
    private final U128 checksum;
    static final Reader READER = new Reader();
    static final OFBsnGentableStatsEntryVer15Funnel FUNNEL = new OFBsnGentableStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableStatsEntryVer15(GenTableId tableId, long entryCount, U128 checksum) {
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableStatsEntryVer15: property tableId cannot be null");
        }
        if (checksum == null) {
            throw new NullPointerException("OFBsnGentableStatsEntryVer15: property checksum cannot be null");
        }
        this.tableId = tableId;
        this.entryCount = entryCount;
        this.checksum = checksum;
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getEntryCount() {
        return this.entryCount;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnGentableStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableStatsEntryVer15(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("entryCount=").append(this.entryCount);
        b.append(", ");
        b.append("checksum=").append(this.checksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableStatsEntryVer15 other = (OFBsnGentableStatsEntryVer15)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.entryCount != other.entryCount) {
            return false;
        }
        return !(this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * (int)(this.entryCount ^ this.entryCount >>> 32);
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableStatsEntryVer15 message) {
            message.tableId.write2Bytes(bb);
            bb.writeZero(2);
            bb.writeInt(U32.t(message.entryCount));
            message.checksum.write16Bytes(bb);
        }
    }

    static class OFBsnGentableStatsEntryVer15Funnel
    implements Funnel<OFBsnGentableStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableStatsEntryVer15Funnel() {
        }

        public void funnel(OFBsnGentableStatsEntryVer15 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            sink.putLong(message.entryCount);
            message.checksum.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGentableStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            GenTableId tableId = GenTableId.read2Bytes(bb);
            bb.skipBytes(2);
            long entryCount = U32.f(bb.readInt());
            U128 checksum = U128.read16Bytes(bb);
            OFBsnGentableStatsEntryVer15 bsnGentableStatsEntryVer15 = new OFBsnGentableStatsEntryVer15(tableId, entryCount, checksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableStatsEntryVer15);
            }
            return bsnGentableStatsEntryVer15;
        }
    }

    static class Builder
    implements OFBsnGentableStatsEntry.Builder {
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean entryCountSet;
        private long entryCount;
        private boolean checksumSet;
        private U128 checksum;

        Builder() {
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableStatsEntry.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getEntryCount() {
            return this.entryCount;
        }

        @Override
        public OFBsnGentableStatsEntry.Builder setEntryCount(long entryCount) {
            this.entryCount = entryCount;
            this.entryCountSet = true;
            return this;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnGentableStatsEntry build() {
            U128 checksum;
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long entryCount = this.entryCountSet ? this.entryCount : 0L;
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnGentableStatsEntryVer15(this.tableId, entryCount, checksum);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableStatsEntry.Builder {
        final OFBsnGentableStatsEntryVer15 parentMessage;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean entryCountSet;
        private long entryCount;
        private boolean checksumSet;
        private U128 checksum;

        BuilderWithParent(OFBsnGentableStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableStatsEntry.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getEntryCount() {
            return this.entryCount;
        }

        @Override
        public OFBsnGentableStatsEntry.Builder setEntryCount(long entryCount) {
            this.entryCount = entryCount;
            this.entryCountSet = true;
            return this;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableStatsEntry.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnGentableStatsEntry build() {
            U128 checksum;
            GenTableId tableId;
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            long entryCount = this.entryCountSet ? this.entryCount : this.parentMessage.entryCount;
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnGentableStatsEntryVer15(tableId, entryCount, checksum);
        }
    }
}

