/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdPushPbb;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdPushPbbVer15
implements OFActionIdPushPbb {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdPushPbbVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFActionIdPushPbbVer15 DEFAULT = new OFActionIdPushPbbVer15();
    static final OFActionIdPushPbbVer15 INSTANCE = new OFActionIdPushPbbVer15();
    static final Reader READER = new Reader();
    static final OFActionIdPushPbbVer15Funnel FUNNEL = new OFActionIdPushPbbVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdPushPbbVer15() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.PUSH_PBB;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionIdPushPbb.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdPushPbbVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdPushPbbVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdPushPbbVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdPushPbbVer15 message) {
            bb.writeShort(26);
            bb.writeShort(4);
        }
    }

    static class OFActionIdPushPbbVer15Funnel
    implements Funnel<OFActionIdPushPbbVer15> {
        private static final long serialVersionUID = 1L;

        OFActionIdPushPbbVer15Funnel() {
        }

        public void funnel(OFActionIdPushPbbVer15 message, PrimitiveSink sink) {
            sink.putShort((short)26);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdPushPbb> {
        Reader() {
        }

        @Override
        public OFActionIdPushPbb readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 26) {
                throw new OFParseError("Wrong type: Expected=OFActionType.PUSH_PBB(26), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

