/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionBsnGentable;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTlvVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionBsnGentableVer15
implements OFActionBsnGentable {
    private static final Logger logger = LoggerFactory.getLogger(OFActionBsnGentableVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_TABLE_ID = 0L;
    private static final List<OFBsnTlv> DEFAULT_KEY = ImmutableList.of();
    private final long tableId;
    private final List<OFBsnTlv> key;
    static final OFActionBsnGentableVer15 DEFAULT = new OFActionBsnGentableVer15(0L, DEFAULT_KEY);
    static final Reader READER = new Reader();
    static final OFActionBsnGentableVer15Funnel FUNNEL = new OFActionBsnGentableVer15Funnel();
    static final Writer WRITER = new Writer();

    OFActionBsnGentableVer15(long tableId, List<OFBsnTlv> key) {
        if (key == null) {
            throw new NullPointerException("OFActionBsnGentableVer15: property key cannot be null");
        }
        this.tableId = tableId;
        this.key = key;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 5L;
    }

    @Override
    public long getTableId() {
        return this.tableId;
    }

    @Override
    public List<OFBsnTlv> getKey() {
        return this.key;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionBsnGentable.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionBsnGentableVer15(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("key=").append(this.key);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionBsnGentableVer15 other = (OFActionBsnGentableVer15)obj;
        if (this.tableId != other.tableId) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.tableId ^ this.tableId >>> 32);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionBsnGentableVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionBsnGentableVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(6035143);
            bb.writeInt(5);
            bb.writeInt(U32.t(message.tableId));
            ChannelUtils.writeList(bb, message.key);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFActionBsnGentableVer15Funnel
    implements Funnel<OFActionBsnGentableVer15> {
        private static final long serialVersionUID = 1L;

        OFActionBsnGentableVer15Funnel() {
        }

        public void funnel(OFActionBsnGentableVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(6035143);
            sink.putInt(5);
            sink.putLong(message.tableId);
            FunnelUtils.putList(message.key, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionBsnGentable> {
        Reader() {
        }

        @Override
        public OFActionBsnGentable readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 5) {
                throw new OFParseError("Wrong subtype: Expected=0x5L(0x5L), got=" + subtype);
            }
            long tableId = U32.f(bb.readInt());
            List<OFBsnTlv> key = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer15.READER);
            OFActionBsnGentableVer15 actionBsnGentableVer15 = new OFActionBsnGentableVer15(tableId, key);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionBsnGentableVer15);
            }
            return actionBsnGentableVer15;
        }
    }

    static class Builder
    implements OFActionBsnGentable.Builder {
        private boolean tableIdSet;
        private long tableId;
        private boolean keySet;
        private List<OFBsnTlv> key;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 5L;
        }

        @Override
        public long getTableId() {
            return this.tableId;
        }

        @Override
        public OFActionBsnGentable.Builder setTableId(long tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFActionBsnGentable.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionBsnGentable build() {
            List<OFBsnTlv> key;
            long tableId = this.tableIdSet ? this.tableId : 0L;
            List<OFBsnTlv> list = key = this.keySet ? this.key : DEFAULT_KEY;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            return new OFActionBsnGentableVer15(tableId, key);
        }
    }

    static class BuilderWithParent
    implements OFActionBsnGentable.Builder {
        final OFActionBsnGentableVer15 parentMessage;
        private boolean tableIdSet;
        private long tableId;
        private boolean keySet;
        private List<OFBsnTlv> key;

        BuilderWithParent(OFActionBsnGentableVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 5L;
        }

        @Override
        public long getTableId() {
            return this.tableId;
        }

        @Override
        public OFActionBsnGentable.Builder setTableId(long tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFActionBsnGentable.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFActionBsnGentable build() {
            List key;
            long tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            List list = key = this.keySet ? this.key : this.parentMessage.key;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            return new OFActionBsnGentableVer15(tableId, key);
        }
    }
}

