/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropApplySetfield;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropApplySetfieldVer14
implements OFTableFeaturePropApplySetfield {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropApplySetfieldVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final List<U32> DEFAULT_OXM_IDS = ImmutableList.of();
    private final List<U32> oxmIds;
    static final OFTableFeaturePropApplySetfieldVer14 DEFAULT = new OFTableFeaturePropApplySetfieldVer14(DEFAULT_OXM_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropApplySetfieldVer14Funnel FUNNEL = new OFTableFeaturePropApplySetfieldVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropApplySetfieldVer14(List<U32> oxmIds) {
        if (oxmIds == null) {
            throw new NullPointerException("OFTableFeaturePropApplySetfieldVer14: property oxmIds cannot be null");
        }
        this.oxmIds = oxmIds;
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public List<U32> getOxmIds() {
        return this.oxmIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeaturePropApplySetfield.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropApplySetfieldVer14(");
        b.append("oxmIds=").append(this.oxmIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropApplySetfieldVer14 other = (OFTableFeaturePropApplySetfieldVer14)obj;
        return !(this.oxmIds == null ? other.oxmIds != null : !this.oxmIds.equals(other.oxmIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxmIds == null ? 0 : this.oxmIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropApplySetfieldVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropApplySetfieldVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(14);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.oxmIds);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFTableFeaturePropApplySetfieldVer14Funnel
    implements Funnel<OFTableFeaturePropApplySetfieldVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropApplySetfieldVer14Funnel() {
        }

        public void funnel(OFTableFeaturePropApplySetfieldVer14 message, PrimitiveSink sink) {
            sink.putShort((short)14);
            FunnelUtils.putList(message.oxmIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropApplySetfield> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropApplySetfield readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 14) {
                throw new OFParseError("Wrong type: Expected=0xe(0xe), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U32> oxmIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U32.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFTableFeaturePropApplySetfieldVer14 tableFeaturePropApplySetfieldVer14 = new OFTableFeaturePropApplySetfieldVer14(oxmIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropApplySetfieldVer14);
            }
            return tableFeaturePropApplySetfieldVer14;
        }
    }

    static class Builder
    implements OFTableFeaturePropApplySetfield.Builder {
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 14;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropApplySetfield.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropApplySetfield build() {
            List<U32> oxmIds;
            List<U32> list = oxmIds = this.oxmIdsSet ? this.oxmIds : DEFAULT_OXM_IDS;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropApplySetfieldVer14(oxmIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropApplySetfield.Builder {
        final OFTableFeaturePropApplySetfieldVer14 parentMessage;
        private boolean oxmIdsSet;
        private List<U32> oxmIds;

        BuilderWithParent(OFTableFeaturePropApplySetfieldVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 14;
        }

        @Override
        public List<U32> getOxmIds() {
            return this.oxmIds;
        }

        @Override
        public OFTableFeaturePropApplySetfield.Builder setOxmIds(List<U32> oxmIds) {
            this.oxmIds = oxmIds;
            this.oxmIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeaturePropApplySetfield build() {
            List oxmIds;
            List list = oxmIds = this.oxmIdsSet ? this.oxmIds : this.parentMessage.oxmIds;
            if (oxmIds == null) {
                throw new NullPointerException("Property oxmIds must not be null");
            }
            return new OFTableFeaturePropApplySetfieldVer14(oxmIds);
        }
    }
}

