/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterBandStats;
import org.projectfloodlight.openflow.protocol.OFMeterStats;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterBandStatsVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterStatsVer14
implements OFMeterStats {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterStatsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 40;
    private static final long DEFAULT_METER_ID = 0L;
    private static final long DEFAULT_FLOW_COUNT = 0L;
    private static final U64 DEFAULT_PACKET_IN_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_IN_COUNT = U64.ZERO;
    private static final long DEFAULT_DURATION_SEC = 0L;
    private static final long DEFAULT_DURATION_NSEC = 0L;
    private static final List<OFMeterBandStats> DEFAULT_BAND_STATS = ImmutableList.of();
    private final long meterId;
    private final long flowCount;
    private final U64 packetInCount;
    private final U64 byteInCount;
    private final long durationSec;
    private final long durationNsec;
    private final List<OFMeterBandStats> bandStats;
    static final OFMeterStatsVer14 DEFAULT = new OFMeterStatsVer14(0L, 0L, DEFAULT_PACKET_IN_COUNT, DEFAULT_BYTE_IN_COUNT, 0L, 0L, DEFAULT_BAND_STATS);
    static final Reader READER = new Reader();
    static final OFMeterStatsVer14Funnel FUNNEL = new OFMeterStatsVer14Funnel();
    static final Writer WRITER = new Writer();

    OFMeterStatsVer14(long meterId, long flowCount, U64 packetInCount, U64 byteInCount, long durationSec, long durationNsec, List<OFMeterBandStats> bandStats) {
        if (packetInCount == null) {
            throw new NullPointerException("OFMeterStatsVer14: property packetInCount cannot be null");
        }
        if (byteInCount == null) {
            throw new NullPointerException("OFMeterStatsVer14: property byteInCount cannot be null");
        }
        if (bandStats == null) {
            throw new NullPointerException("OFMeterStatsVer14: property bandStats cannot be null");
        }
        this.meterId = meterId;
        this.flowCount = flowCount;
        this.packetInCount = packetInCount;
        this.byteInCount = byteInCount;
        this.durationSec = durationSec;
        this.durationNsec = durationNsec;
        this.bandStats = bandStats;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public long getFlowCount() {
        return this.flowCount;
    }

    @Override
    public U64 getPacketInCount() {
        return this.packetInCount;
    }

    @Override
    public U64 getByteInCount() {
        return this.byteInCount;
    }

    @Override
    public long getDurationSec() {
        return this.durationSec;
    }

    @Override
    public long getDurationNsec() {
        return this.durationNsec;
    }

    @Override
    public List<OFMeterBandStats> getBandStats() {
        return this.bandStats;
    }

    @Override
    public long getRefCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property refCount not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFMeterStats.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterStatsVer14(");
        b.append("meterId=").append(this.meterId);
        b.append(", ");
        b.append("flowCount=").append(this.flowCount);
        b.append(", ");
        b.append("packetInCount=").append(this.packetInCount);
        b.append(", ");
        b.append("byteInCount=").append(this.byteInCount);
        b.append(", ");
        b.append("durationSec=").append(this.durationSec);
        b.append(", ");
        b.append("durationNsec=").append(this.durationNsec);
        b.append(", ");
        b.append("bandStats=").append(this.bandStats);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterStatsVer14 other = (OFMeterStatsVer14)obj;
        if (this.meterId != other.meterId) {
            return false;
        }
        if (this.flowCount != other.flowCount) {
            return false;
        }
        if (this.packetInCount == null ? other.packetInCount != null : !this.packetInCount.equals(other.packetInCount)) {
            return false;
        }
        if (this.byteInCount == null ? other.byteInCount != null : !this.byteInCount.equals(other.byteInCount)) {
            return false;
        }
        if (this.durationSec != other.durationSec) {
            return false;
        }
        if (this.durationNsec != other.durationNsec) {
            return false;
        }
        return !(this.bandStats == null ? other.bandStats != null : !this.bandStats.equals(other.bandStats));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        result = 31 * (int)(this.flowCount ^ this.flowCount >>> 32);
        result = 31 * result + (this.packetInCount == null ? 0 : this.packetInCount.hashCode());
        result = 31 * result + (this.byteInCount == null ? 0 : this.byteInCount.hashCode());
        result = 31 * (int)(this.durationSec ^ this.durationSec >>> 32);
        result = 31 * (int)(this.durationNsec ^ this.durationNsec >>> 32);
        result = 31 * result + (this.bandStats == null ? 0 : this.bandStats.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterStatsVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterStatsVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeInt(U32.t(message.meterId));
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(6);
            bb.writeInt(U32.t(message.flowCount));
            bb.writeLong(message.packetInCount.getValue());
            bb.writeLong(message.byteInCount.getValue());
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
            ChannelUtils.writeList(bb, message.bandStats);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFMeterStatsVer14Funnel
    implements Funnel<OFMeterStatsVer14> {
        private static final long serialVersionUID = 1L;

        OFMeterStatsVer14Funnel() {
        }

        public void funnel(OFMeterStatsVer14 message, PrimitiveSink sink) {
            sink.putLong(message.meterId);
            sink.putLong(message.flowCount);
            message.packetInCount.putTo(sink);
            message.byteInCount.putTo(sink);
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
            FunnelUtils.putList(message.bandStats, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterStats> {
        Reader() {
        }

        @Override
        public OFMeterStats readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            long meterId = U32.f(bb.readInt());
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(6);
            long flowCount = U32.f(bb.readInt());
            U64 packetInCount = U64.ofRaw(bb.readLong());
            U64 byteInCount = U64.ofRaw(bb.readLong());
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            List<OFMeterBandStats> bandStats = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFMeterBandStatsVer14.READER);
            OFMeterStatsVer14 meterStatsVer14 = new OFMeterStatsVer14(meterId, flowCount, packetInCount, byteInCount, durationSec, durationNsec, bandStats);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterStatsVer14);
            }
            return meterStatsVer14;
        }
    }

    static class Builder
    implements OFMeterStats.Builder {
        private boolean meterIdSet;
        private long meterId;
        private boolean flowCountSet;
        private long flowCount;
        private boolean packetInCountSet;
        private U64 packetInCount;
        private boolean byteInCountSet;
        private U64 byteInCount;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean bandStatsSet;
        private List<OFMeterBandStats> bandStats;

        Builder() {
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterStats.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public long getFlowCount() {
            return this.flowCount;
        }

        @Override
        public OFMeterStats.Builder setFlowCount(long flowCount) {
            this.flowCount = flowCount;
            this.flowCountSet = true;
            return this;
        }

        @Override
        public U64 getPacketInCount() {
            return this.packetInCount;
        }

        @Override
        public OFMeterStats.Builder setPacketInCount(U64 packetInCount) {
            this.packetInCount = packetInCount;
            this.packetInCountSet = true;
            return this;
        }

        @Override
        public U64 getByteInCount() {
            return this.byteInCount;
        }

        @Override
        public OFMeterStats.Builder setByteInCount(U64 byteInCount) {
            this.byteInCount = byteInCount;
            this.byteInCountSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFMeterStats.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFMeterStats.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public List<OFMeterBandStats> getBandStats() {
            return this.bandStats;
        }

        @Override
        public OFMeterStats.Builder setBandStats(List<OFMeterBandStats> bandStats) {
            this.bandStats = bandStats;
            this.bandStatsSet = true;
            return this;
        }

        @Override
        public long getRefCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property refCount not supported in version 1.4");
        }

        @Override
        public OFMeterStats.Builder setRefCount(long refCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property refCount not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFMeterStats build() {
            List<OFMeterBandStats> bandStats;
            U64 byteInCount;
            U64 packetInCount;
            long meterId = this.meterIdSet ? this.meterId : 0L;
            long flowCount = this.flowCountSet ? this.flowCount : 0L;
            U64 u64 = packetInCount = this.packetInCountSet ? this.packetInCount : DEFAULT_PACKET_IN_COUNT;
            if (packetInCount == null) {
                throw new NullPointerException("Property packetInCount must not be null");
            }
            U64 u642 = byteInCount = this.byteInCountSet ? this.byteInCount : DEFAULT_BYTE_IN_COUNT;
            if (byteInCount == null) {
                throw new NullPointerException("Property byteInCount must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : 0L;
            long durationNsec = this.durationNsecSet ? this.durationNsec : 0L;
            List<OFMeterBandStats> list = bandStats = this.bandStatsSet ? this.bandStats : DEFAULT_BAND_STATS;
            if (bandStats == null) {
                throw new NullPointerException("Property bandStats must not be null");
            }
            return new OFMeterStatsVer14(meterId, flowCount, packetInCount, byteInCount, durationSec, durationNsec, bandStats);
        }
    }

    static class BuilderWithParent
    implements OFMeterStats.Builder {
        final OFMeterStatsVer14 parentMessage;
        private boolean meterIdSet;
        private long meterId;
        private boolean flowCountSet;
        private long flowCount;
        private boolean packetInCountSet;
        private U64 packetInCount;
        private boolean byteInCountSet;
        private U64 byteInCount;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean bandStatsSet;
        private List<OFMeterBandStats> bandStats;

        BuilderWithParent(OFMeterStatsVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterStats.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public long getFlowCount() {
            return this.flowCount;
        }

        @Override
        public OFMeterStats.Builder setFlowCount(long flowCount) {
            this.flowCount = flowCount;
            this.flowCountSet = true;
            return this;
        }

        @Override
        public U64 getPacketInCount() {
            return this.packetInCount;
        }

        @Override
        public OFMeterStats.Builder setPacketInCount(U64 packetInCount) {
            this.packetInCount = packetInCount;
            this.packetInCountSet = true;
            return this;
        }

        @Override
        public U64 getByteInCount() {
            return this.byteInCount;
        }

        @Override
        public OFMeterStats.Builder setByteInCount(U64 byteInCount) {
            this.byteInCount = byteInCount;
            this.byteInCountSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFMeterStats.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFMeterStats.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public List<OFMeterBandStats> getBandStats() {
            return this.bandStats;
        }

        @Override
        public OFMeterStats.Builder setBandStats(List<OFMeterBandStats> bandStats) {
            this.bandStats = bandStats;
            this.bandStatsSet = true;
            return this;
        }

        @Override
        public long getRefCount() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property refCount not supported in version 1.4");
        }

        @Override
        public OFMeterStats.Builder setRefCount(long refCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property refCount not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFMeterStats build() {
            List bandStats;
            U64 byteInCount;
            U64 packetInCount;
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            long flowCount = this.flowCountSet ? this.flowCount : this.parentMessage.flowCount;
            U64 u64 = packetInCount = this.packetInCountSet ? this.packetInCount : this.parentMessage.packetInCount;
            if (packetInCount == null) {
                throw new NullPointerException("Property packetInCount must not be null");
            }
            U64 u642 = byteInCount = this.byteInCountSet ? this.byteInCount : this.parentMessage.byteInCount;
            if (byteInCount == null) {
                throw new NullPointerException("Property byteInCount must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : this.parentMessage.durationSec;
            long durationNsec = this.durationNsecSet ? this.durationNsec : this.parentMessage.durationNsec;
            List list = bandStats = this.bandStatsSet ? this.bandStats : this.parentMessage.bandStats;
            if (bandStats == null) {
                throw new NullPointerException("Property bandStats must not be null");
            }
            return new OFMeterStatsVer14(meterId, flowCount, packetInCount, byteInCount, durationSec, durationNsec, bandStats);
        }
    }
}

