/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.instruction.OFInstruction;
import org.projectfloodlight.openflow.protocol.ver14.OFInstructionApplyActionsVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFInstructionClearActionsVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFInstructionExperimenterVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFInstructionGotoTableVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFInstructionMeterVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFInstructionWriteActionsVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFInstructionWriteMetadataVer14;

abstract class OFInstructionVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    public static final Reader READER = new Reader();

    OFInstructionVer14() {
    }

    static class Reader
    implements OFMessageReader<OFInstruction> {
        Reader() {
        }

        @Override
        public OFInstruction readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 4) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            bb.readerIndex(start);
            switch (type) {
                case 4: {
                    return OFInstructionApplyActionsVer14.READER.readFrom(bb);
                }
                case 5: {
                    return OFInstructionClearActionsVer14.READER.readFrom(bb);
                }
                case -1: {
                    return OFInstructionExperimenterVer14.READER.readFrom(bb);
                }
                case 1: {
                    return OFInstructionGotoTableVer14.READER.readFrom(bb);
                }
                case 3: {
                    return OFInstructionWriteActionsVer14.READER.readFrom(bb);
                }
                case 2: {
                    return OFInstructionWriteMetadataVer14.READER.readFrom(bb);
                }
                case 6: {
                    return OFInstructionMeterVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFInstructionVer14: " + type);
        }
    }
}

