/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFGroupProp;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFBucketVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFGroupTypeSerializerVer14;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupDescStatsEntryVer14
implements OFGroupDescStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupDescStatsEntryVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 8;
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private static final List<OFBucket> DEFAULT_BUCKETS = ImmutableList.of();
    private final OFGroupType groupType;
    private final OFGroup group;
    private final List<OFBucket> buckets;
    static final Reader READER = new Reader();
    static final OFGroupDescStatsEntryVer14Funnel FUNNEL = new OFGroupDescStatsEntryVer14Funnel();
    static final Writer WRITER = new Writer();

    OFGroupDescStatsEntryVer14(OFGroupType groupType, OFGroup group, List<OFBucket> buckets) {
        if (groupType == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer14: property groupType cannot be null");
        }
        if (group == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer14: property group cannot be null");
        }
        if (buckets == null) {
            throw new NullPointerException("OFGroupDescStatsEntryVer14: property buckets cannot be null");
        }
        this.groupType = groupType;
        this.group = group;
        this.buckets = buckets;
    }

    @Override
    public OFGroupType getGroupType() {
        return this.groupType;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public List<OFBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public List<OFGroupProp> getProperties() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property properties not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFGroupDescStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupDescStatsEntryVer14(");
        b.append("groupType=").append((Object)this.groupType);
        b.append(", ");
        b.append("group=").append(this.group);
        b.append(", ");
        b.append("buckets=").append(this.buckets);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupDescStatsEntryVer14 other = (OFGroupDescStatsEntryVer14)obj;
        if (this.groupType == null ? other.groupType != null : !this.groupType.equals((Object)other.groupType)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        return !(this.buckets == null ? other.buckets != null : !this.buckets.equals(other.buckets));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupType == null ? 0 : this.groupType.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.buckets == null ? 0 : this.buckets.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupDescStatsEntryVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupDescStatsEntryVer14 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            OFGroupTypeSerializerVer14.writeTo(bb, message.groupType);
            bb.writeZero(1);
            message.group.write4Bytes(bb);
            ChannelUtils.writeList(bb, message.buckets);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFGroupDescStatsEntryVer14Funnel
    implements Funnel<OFGroupDescStatsEntryVer14> {
        private static final long serialVersionUID = 1L;

        OFGroupDescStatsEntryVer14Funnel() {
        }

        public void funnel(OFGroupDescStatsEntryVer14 message, PrimitiveSink sink) {
            OFGroupTypeSerializerVer14.putTo(message.groupType, sink);
            message.group.putTo(sink);
            FunnelUtils.putList(message.buckets, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupDescStatsEntry> {
        Reader() {
        }

        @Override
        public OFGroupDescStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFGroupType groupType = OFGroupTypeSerializerVer14.readFrom(bb);
            bb.skipBytes(1);
            OFGroup group = OFGroup.read4Bytes(bb);
            List<OFBucket> buckets = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBucketVer14.READER);
            OFGroupDescStatsEntryVer14 groupDescStatsEntryVer14 = new OFGroupDescStatsEntryVer14(groupType, group, buckets);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupDescStatsEntryVer14);
            }
            return groupDescStatsEntryVer14;
        }
    }

    static class Builder
    implements OFGroupDescStatsEntry.Builder {
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean bucketsSet;
        private List<OFBucket> buckets;

        Builder() {
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public List<OFGroupProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.4");
        }

        @Override
        public OFGroupDescStatsEntry.Builder setProperties(List<OFGroupProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFGroupDescStatsEntry build() {
            List<OFBucket> buckets;
            OFGroup group;
            if (!this.groupTypeSet) {
                throw new IllegalStateException("Property groupType doesn't have default value -- must be set");
            }
            if (this.groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            List<OFBucket> list = buckets = this.bucketsSet ? this.buckets : DEFAULT_BUCKETS;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            return new OFGroupDescStatsEntryVer14(this.groupType, group, buckets);
        }
    }

    static class BuilderWithParent
    implements OFGroupDescStatsEntry.Builder {
        final OFGroupDescStatsEntryVer14 parentMessage;
        private boolean groupTypeSet;
        private OFGroupType groupType;
        private boolean groupSet;
        private OFGroup group;
        private boolean bucketsSet;
        private List<OFBucket> buckets;

        BuilderWithParent(OFGroupDescStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroupType(OFGroupType groupType) {
            this.groupType = groupType;
            this.groupTypeSet = true;
            return this;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public List<OFBucket> getBuckets() {
            return this.buckets;
        }

        @Override
        public OFGroupDescStatsEntry.Builder setBuckets(List<OFBucket> buckets) {
            this.buckets = buckets;
            this.bucketsSet = true;
            return this;
        }

        @Override
        public List<OFGroupProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.4");
        }

        @Override
        public OFGroupDescStatsEntry.Builder setProperties(List<OFGroupProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFGroupDescStatsEntry build() {
            List buckets;
            OFGroup group;
            OFGroupType groupType;
            OFGroupType oFGroupType = groupType = this.groupTypeSet ? this.groupType : this.parentMessage.groupType;
            if (groupType == null) {
                throw new NullPointerException("Property groupType must not be null");
            }
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            List list = buckets = this.bucketsSet ? this.buckets : this.parentMessage.buckets;
            if (buckets == null) {
                throw new NullPointerException("Property buckets must not be null");
            }
            return new OFGroupDescStatsEntryVer14(groupType, group, buckets);
        }
    }
}

