/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvKnownMulticastRate;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvKnownMulticastRateVer14
implements OFBsnTlvKnownMulticastRate {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvKnownMulticastRateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvKnownMulticastRateVer14 DEFAULT = new OFBsnTlvKnownMulticastRateVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvKnownMulticastRateVer14Funnel FUNNEL = new OFBsnTlvKnownMulticastRateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvKnownMulticastRateVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 91;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvKnownMulticastRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvKnownMulticastRateVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvKnownMulticastRateVer14 other = (OFBsnTlvKnownMulticastRateVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvKnownMulticastRateVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvKnownMulticastRateVer14 message) {
            bb.writeShort(91);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvKnownMulticastRateVer14Funnel
    implements Funnel<OFBsnTlvKnownMulticastRateVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvKnownMulticastRateVer14Funnel() {
        }

        public void funnel(OFBsnTlvKnownMulticastRateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)91);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvKnownMulticastRate> {
        Reader() {
        }

        @Override
        public OFBsnTlvKnownMulticastRate readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 91) {
                throw new OFParseError("Wrong type: Expected=0x5b(0x5b), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvKnownMulticastRateVer14 bsnTlvKnownMulticastRateVer14 = new OFBsnTlvKnownMulticastRateVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvKnownMulticastRateVer14);
            }
            return bsnTlvKnownMulticastRateVer14;
        }
    }

    static class Builder
    implements OFBsnTlvKnownMulticastRate.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 91;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvKnownMulticastRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvKnownMulticastRate build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvKnownMulticastRateVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvKnownMulticastRate.Builder {
        final OFBsnTlvKnownMulticastRateVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvKnownMulticastRateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 91;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvKnownMulticastRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvKnownMulticastRate build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvKnownMulticastRateVer14(value);
        }
    }
}

